/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.test.framework;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.blocks.storage.tank.creativetank.CreativeTankBlockEntity;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.test.framework.PipeBuilder;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MIGameTestHelper
extends GameTestHelper {
    public MIGameTestHelper(GameTestInfo testInfo) {
        super(testInfo);
    }

    public void creativeTank(BlockPos pos, Fluid fluid) {
        this.setBlock(pos, MIBlock.CREATIVE_TANK.get());
        CreativeTankBlockEntity tank = (CreativeTankBlockEntity)this.getBlockEntity(pos);
        tank.setFluid(FluidVariant.of(fluid));
    }

    public void emptyTank(BlockPos pos) {
        this.emptyTank(pos, MIMaterials.IRIDIUM);
    }

    public void emptyTank(BlockPos pos, Material material) {
        this.setBlock(pos, material.getPart(MIParts.TANK).asBlock());
    }

    public void assertAir(BlockPos pos) {
        this.assertBlockPresent(Blocks.AIR, pos);
    }

    public void pipe(BlockPos pos, PipeNetworkType type, Consumer<? super PipeBuilder> setup) {
        this.assertAir(pos);
        this.setBlock(pos, MIPipes.BLOCK_PIPE.get());
        PipeBlockEntity pipeBe = (PipeBlockEntity)this.getBlockEntity(pos);
        PipeItem item = MIPipes.INSTANCE.getPipeItem(type);
        pipeBe.addPipe(type, item.defaultData);
        this.getLevel().blockUpdated(this.absolutePos(pos), Blocks.AIR);
        setup.accept(new PipeBuilder(this, pipeBe, type));
    }

    public PipeNetworkNode getPipeNode(BlockPos pos, PipeNetworkType type) {
        PipeBlockEntity pipeBe = (PipeBlockEntity)this.getBlockEntity(pos);
        for (PipeNetworkNode node : pipeBe.getNodes()) {
            if (node.getType() != type) continue;
            return node;
        }
        this.fail("Could not find pipe node " + String.valueOf(type.getIdentifier()), pos);
        throw new RuntimeException("Unreachable!");
    }

    public void assertFluid(BlockPos pos, Fluid fluid, int amount) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, this.absolutePos(pos), null);
        if (fluidHandler == null) {
            this.fail("Could not find fluid handler", pos);
        }
        boolean foundAny = false;
        ResourceLocation fluidName = BuiltInRegistries.FLUID.getKey((Object)fluid);
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack stack = fluidHandler.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            if (stack.is(fluid) && stack.getAmount() == amount) {
                foundAny = true;
                continue;
            }
            this.fail("Expected fluid %s and amount %d, got %s".formatted(fluidName, amount, stack), pos);
        }
        if (!foundAny) {
            this.fail("Expected fluid %s and amount %d, got nothing".formatted(fluidName, amount), pos);
        }
    }

    public void assertNoFluid(BlockPos pos) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, this.absolutePos(pos), null);
        if (fluidHandler == null) {
            this.fail("Could not find fluid handler", pos);
        }
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack stack = fluidHandler.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            this.fail("Expected no fluid, got %s".formatted(stack), pos);
        }
    }
}

