/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadEmitter;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class PipeMeshBuilder
extends PipePartBuilder {
    protected final QuadEmitter emitter;
    private final TextureAtlasSprite sprite;
    private final float spriteSizeU;
    private final float spriteSizeV;
    private static final double COL_WIDTH = 0.125;
    private static final double[] BEND_COL = new double[]{0.0, 0.125, 0.0, 0.25};
    private static final double[] BEND_CONFLICTING_COL = new double[]{0.0, 0.5, 0.0, 0.625};
    private static final double[] STRAIGHT_COL = new double[]{0.75, 0.75, 0.75, 0.75};
    private static final int[][] CENTER_PATTERNS = new int[][]{{1, 0, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 1}, {1, 0, 1, 1}, {0, 0, 0, 1}};
    private static final double[][] CENTER_UVS = new double[][]{{0.0, 0.0}, {0.125, 0.0}, {0.375, 0.0}, {0.375, 0.125}, {0.375, 0.25}, {0.375, 0.375}};

    PipeMeshBuilder(QuadEmitter emitter, int slotPos, Direction direction, TextureAtlasSprite sprite) {
        super(slotPos, direction);
        this.emitter = emitter;
        this.sprite = sprite;
        this.spriteSizeU = sprite.getU1() - sprite.getU0();
        this.spriteSizeV = sprite.getV1() - sprite.getV0();
    }

    protected void quad(Direction direction, float left, float bottom, float right, float top, float depth) {
        this.emitter.square(direction, left, bottom, right, top, depth);
        this.emitter.cullFace(null);
    }

    private void quad(Direction direction, double left, double bottom, double right, double top, double depth) {
        this.quad(direction, (float)left, (float)bottom, (float)right, (float)top, (float)depth);
    }

    private void quad(Vec3 facing, Vec3[] corners, Vec3[] uvs) {
        if (corners.length != 4 || uvs.length != 4) {
            throw new RuntimeException("This is a bug, please report!");
        }
        Vec3 c1 = corners[0];
        Vec3 c4 = corners[3];
        Direction direction = Direction.getNearest((double)facing.x, (double)facing.y, (double)facing.z);
        double x = Math.min(c1.x, c4.x);
        double y = Math.min(c1.y, c4.y);
        double z = Math.min(c1.z, c4.z);
        double X = Math.max(c1.x, c4.x);
        double Y = Math.max(c1.y, c4.y);
        double Z = Math.max(c1.z, c4.z);
        if (direction == Direction.UP) {
            this.quad(Direction.UP, x, 1.0 - Z, X, 1.0 - z, 1.0 - Y);
        } else if (direction == Direction.DOWN) {
            this.quad(Direction.DOWN, x, z, X, Z, y);
        } else if (direction == Direction.NORTH) {
            this.quad(Direction.NORTH, 1.0 - X, y, 1.0 - x, Y, z);
        } else if (direction == Direction.EAST) {
            this.quad(Direction.EAST, 1.0 - Z, y, 1.0 - z, Y, 1.0 - X);
        } else if (direction == Direction.SOUTH) {
            this.quad(Direction.SOUTH, x, y, X, Y, 1.0 - Z);
        } else {
            this.quad(Direction.WEST, z, y, Z, Y, x);
        }
        for (int i = 0; i < 4; ++i) {
            Vec3 vertexPos = new Vec3(this.emitter.copyPos(i, null));
            for (int j = 0; j < 4; ++j) {
                if (!(vertexPos.subtract(corners[j]).lengthSqr() < 1.0E-6)) continue;
                float realU = this.sprite.getU0() + this.spriteSizeU * (float)uvs[j].x();
                float realV = this.sprite.getV0() + this.spriteSizeV * (float)uvs[j].y();
                this.emitter.uv(i, realU, realV);
            }
        }
        this.emitter.emit();
    }

    @Override
    void drawPipe(float length, PipePartBuilder.Intent intent, boolean end) {
        if ((double)length <= 1.0E-9) {
            return;
        }
        double[] cols = intent == PipePartBuilder.Intent.STRAIGHT ? STRAIGHT_COL : (intent == PipePartBuilder.Intent.BEND ? BEND_COL : BEND_CONFLICTING_COL);
        for (int i = 0; i < 4; ++i) {
            if (intent != PipePartBuilder.Intent.STRAIGHT && i == 0) {
                length -= 0.125f;
            }
            double u = cols[i];
            Vec3 up = this.up();
            Vec3 base = this.pos.add(up.scale(0.0625));
            this.quad(up, new Vec3[]{base.add(this.right.scale(0.0625)), base.subtract(this.right.scale(0.0625)), base.add(this.right.scale(0.0625)).add(this.facing.scale((double)length)), base.subtract(this.right.scale(0.0625)).add(this.facing.scale((double)length))}, new Vec3[]{new Vec3(u + 0.125, (double)length, 0.0), new Vec3(u, (double)length, 0.0), new Vec3(u + 0.125, 0.0, 0.0), new Vec3(u, 0.0, 0.0)});
            this.rotateCw();
            if (intent == PipePartBuilder.Intent.STRAIGHT || i != 0) continue;
            length += 0.125f;
        }
        if (end) {
            Vec3[] vec3Array;
            Vec3 up = this.up();
            Vec3 base = this.pos.add(this.facing.scale((double)length));
            Vec3[] vec3Array2 = new Vec3[]{base.subtract(up.scale(0.0625)).subtract(this.right.scale(0.0625)), base.subtract(up.scale(0.0625)).add(this.right.scale(0.0625)), base.add(up.scale(0.0625)).subtract(this.right.scale(0.0625)), base.add(up.scale(0.0625)).add(this.right.scale(0.0625))};
            if (intent == PipePartBuilder.Intent.STRAIGHT) {
                Vec3[] vec3Array3 = new Vec3[4];
                vec3Array3[0] = new Vec3(0.5, 0.0, 0.0);
                vec3Array3[1] = new Vec3(0.375, 0.0, 0.0);
                vec3Array3[2] = new Vec3(0.5, 0.125, 0.0);
                vec3Array = vec3Array3;
                vec3Array3[3] = new Vec3(0.375, 0.125, 0.0);
            } else {
                Vec3[] vec3Array4 = new Vec3[4];
                vec3Array4[0] = new Vec3(0.125, 1.0, 0.0);
                vec3Array4[1] = new Vec3(0.0, 1.0, 0.0);
                vec3Array4[2] = new Vec3(0.125, 0.875, 0.0);
                vec3Array = vec3Array4;
                vec3Array4[3] = new Vec3(0.0, 0.875, 0.0);
            }
            this.quad(this.facing, vec3Array2, vec3Array);
        }
    }

    void noConnection(int directions) {
        int i;
        if ((directions & 1 << Direction.getNearest((double)this.facing.x, (double)this.facing.y, (double)this.facing.z).get3DDataValue()) > 0) {
            return;
        }
        int[] sidesDirections = new int[4];
        for (i = 0; i < 4; ++i) {
            Vec3 up = this.up();
            Direction sideDir = Direction.getNearest((double)up.x, (double)up.y, (double)up.z);
            sidesDirections[i] = directions >> sideDir.get3DDataValue() & 1;
            this.rotateCw();
        }
        for (i = 0; i < CENTER_PATTERNS.length; ++i) {
            block2: for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (CENTER_PATTERNS[i][k] != sidesDirections[(j + k) % 4]) continue block2;
                }
                Vec3 up = this.up();
                Vec3[] vertices = new Vec3[]{this.pos.add(this.right.scale(0.0625)).subtract(up.scale(0.0625)), this.pos.add(this.right.scale(0.0625)).add(up.scale(0.0625)), this.pos.subtract(this.right.scale(0.0625)).subtract(up.scale(0.0625)), this.pos.subtract(this.right.scale(0.0625)).add(up.scale(0.0625))};
                double u = CENTER_UVS[i][0];
                double v = CENTER_UVS[i][1];
                Vec3[] uvs = new Vec3[]{new Vec3(u, v + 0.125, 0.0), new Vec3(u, v, 0.0), new Vec3(u + 0.125, v + 0.125, 0.0), new Vec3(u + 0.125, v, 0.0)};
                for (int k = 0; k < j; ++k) {
                    this.rotate(vertices);
                }
                this.quad(this.facing, vertices, uvs);
                return;
            }
        }
    }

    private void rotate(Vec3[] arr) {
        Vec3 tmp = arr[0];
        arr[0] = arr[2];
        arr[2] = arr[3];
        arr[3] = arr[1];
        arr[1] = tmp;
    }

    public static class InnerQuads
    extends PipeMeshBuilder {
        InnerQuads(QuadEmitter emitter, int slotPos, Direction direction, TextureAtlasSprite sprite) {
            super(emitter, slotPos, direction, sprite);
        }

        @Override
        protected void quad(Direction direction, float left, float bottom, float right, float top, float depth) {
            super.quad(direction, left, bottom, right, top, depth + 0.001f);
            this.emitter.tag(1);
            this.emitter.emit();
            super.quad(direction, left, bottom, right, top, depth);
        }
    }
}

