/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TemperatureBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;
        public final int temperatureMax;

        public Parameters(int renderX, int renderY, int temperatureMax) {
            this.renderX = renderX;
            this.renderY = renderY;
            this.temperatureMax = temperatureMax;
        }
    }

    public static class Server
    implements GuiComponent.Server<Integer> {
        private final Parameters params;
        private final Supplier<Integer> temperatureSupplier;

        public Server(Parameters params, Supplier<Integer> temperatureSupplier) {
            this.params = params;
            this.temperatureSupplier = temperatureSupplier;
        }

        @Override
        public Integer copyData() {
            return this.temperatureSupplier.get();
        }

        @Override
        public boolean needsSync(Integer cachedData) {
            return !cachedData.equals(this.temperatureSupplier.get());
        }

        @Override
        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            buf.writeInt(this.params.temperatureMax);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.temperatureSupplier.get().intValue());
        }

        @Override
        public ResourceLocation getId() {
            return GuiComponents.TEMPERATURE_BAR;
        }
    }
}

