/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.blocks.storage.ResourceStorage;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import com.google.common.primitives.Ints;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;

public interface ContainerItem<T extends TransferVariant<?>> {
    default public T getResource(ItemStack stack) {
        return ((ResourceStorage)stack.getOrDefault(this.getComponentType(), this.getDefaultComponent())).resource();
    }

    default public void setResourceNoClean(ItemStack stack, T resource) {
        stack.update(this.getComponentType(), this.getDefaultComponent(), resource, ResourceStorage::withResource);
        this.onChange(stack);
    }

    default public void setResource(ItemStack stack, T resource) {
        this.setResourceNoClean(stack, resource);
        this.clean(stack);
    }

    default public boolean isUnlocked(ItemStack stack) {
        if (this.getBehaviour().isLockable()) {
            return !((ResourceStorage)stack.getOrDefault(this.getComponentType(), this.getDefaultComponent())).locked();
        }
        return true;
    }

    default public void setLockedNoClean(ItemStack stack, boolean locked) {
        if (this.getBehaviour().isLockable()) {
            stack.update(this.getComponentType(), this.getDefaultComponent(), (Object)locked, ResourceStorage::withLocked);
        }
    }

    default public void setLocked(ItemStack stack, boolean locked) {
        this.setLockedNoClean(stack, locked);
        this.clean(stack);
    }

    default public long getAmount(ItemStack stack) {
        ResourceStorage component = (ResourceStorage)stack.getOrDefault(this.getComponentType(), this.getDefaultComponent());
        if (component.resource().isBlank()) {
            return 0L;
        }
        if (this.getBehaviour().isCreative()) {
            return Long.MAX_VALUE;
        }
        return component.amount();
    }

    default public void setAmountNoClean(ItemStack stack, long amount) {
        if (!this.getBehaviour().isCreative()) {
            stack.update(this.getComponentType(), this.getDefaultComponent(), (Object)amount, ResourceStorage::withAmount);
            this.onChange(stack);
        }
    }

    default public void setAmount(ItemStack stack, long amount) {
        this.setAmountNoClean(stack, amount);
        this.clean(stack);
    }

    default public void clean(ItemStack stack) {
        ResourceStorage component = (ResourceStorage)stack.get(this.getComponentType());
        if (component != null && !component.locked() && (component.resource().isBlank() || component.amount() == 0L)) {
            stack.remove(this.getComponentType());
        }
    }

    default public boolean isEmpty(ItemStack stack) {
        return ((ResourceStorage)stack.getOrDefault(this.getComponentType(), this.getDefaultComponent())).amount() == 0L;
    }

    default public void onChange(ItemStack stack) {
    }

    public StorageBehaviour<T> getBehaviour();

    public DataComponentType<ResourceStorage<T>> getComponentType();

    public ResourceStorage<T> getDefaultComponent();

    public static class FluidHandler
    extends BaseHandler<FluidVariant>
    implements IFluidHandlerItem {
        public FluidHandler(ItemStack stack, ContainerItem<FluidVariant> containerItem) {
            super(stack, containerItem);
        }

        public ItemStack getContainer() {
            return this.stack;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int slot) {
            return ((FluidVariant)this.getResource()).toStack(Ints.saturatedCast((long)this.getAmount()));
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.fill(resource, action, false, false);
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action, boolean ignoreFilter, boolean ignoreLock) {
            if (stack.isEmpty()) {
                return 0;
            }
            if (this.containerItem.getBehaviour().isCreative()) {
                return 0;
            }
            FluidVariant resource = FluidVariant.of(stack);
            if ((this.containerItem.getBehaviour().canInsert(resource) || ignoreFilter) && (this.isResourceBlank() && (ignoreLock || this.containerItem.isUnlocked(this.stack)) || ((FluidVariant)this.getResource()).equals(resource))) {
                long amount = this.getAmount();
                int inserted = (int)Math.min((long)stack.getAmount(), this.containerItem.getBehaviour().getCapacityForResource(resource) - amount);
                if (inserted > 0 && action.execute()) {
                    this.update(resource, amount + (long)inserted);
                }
                return inserted;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.isResourceBlank() || !((FluidVariant)this.getResource()).matches(resource)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        public FluidStack drain(int maxAmount, IFluidHandler.FluidAction action) {
            if (maxAmount <= 0 || this.isResourceBlank()) {
                return FluidStack.EMPTY;
            }
            FluidVariant resource = (FluidVariant)this.getResource();
            if (this.containerItem.getBehaviour().canExtract(resource)) {
                if (this.containerItem.getBehaviour().isCreative()) {
                    return resource.toStack(maxAmount);
                }
                long amount = this.getAmount();
                int extracted = (int)Math.min((long)maxAmount, amount);
                if (extracted > 0 && action.execute()) {
                    this.update(resource, amount - (long)extracted);
                }
                return resource.toStack(extracted);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int slot) {
            return Ints.saturatedCast((long)this.containerItem.getBehaviour().getCapacityForResource(FluidVariant.blank()));
        }

        public boolean isFluidValid(int slot, FluidStack stack) {
            return this.containerItem.getBehaviour().canInsert(FluidVariant.of(stack));
        }
    }

    public static class ItemHandler
    extends BaseHandler<ItemVariant>
    implements IItemHandler {
        public ItemHandler(ItemStack stack, ContainerItem<ItemVariant> containerItem) {
            super(stack, containerItem);
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ((ItemVariant)this.getResource()).toStack(Ints.saturatedCast((long)this.getAmount()));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate, false, false);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, boolean ignoreFilter, boolean ignoreLock) {
            if (stack.isEmpty() || slot != 0) {
                return stack;
            }
            if (this.containerItem.getBehaviour().isCreative()) {
                return stack;
            }
            ItemVariant resource = ItemVariant.of(stack);
            if ((this.containerItem.getBehaviour().canInsert(resource) || ignoreFilter) && (this.isResourceBlank() && (ignoreLock || this.containerItem.isUnlocked(this.stack)) || ((ItemVariant)this.getResource()).equals(resource))) {
                long amount = this.getAmount();
                int inserted = (int)Math.min((long)stack.getCount(), this.containerItem.getBehaviour().getCapacityForResource(resource) - amount);
                if (inserted > 0 && !simulate) {
                    this.update(resource, amount + (long)inserted);
                }
                return stack.copyWithCount(stack.getCount() - inserted);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int maxAmount, boolean simulate) {
            if (slot != 0 || maxAmount <= 0 || this.isResourceBlank()) {
                return ItemStack.EMPTY;
            }
            ItemVariant resource = (ItemVariant)this.getResource();
            if (this.containerItem.getBehaviour().canExtract(resource)) {
                if (this.containerItem.getBehaviour().isCreative()) {
                    return resource.toStack(maxAmount);
                }
                long amount = this.getAmount();
                int extracted = (int)Math.min((long)maxAmount, amount);
                if (extracted > 0 && !simulate) {
                    this.update(resource, amount - (long)extracted);
                }
                return resource.toStack(extracted);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Ints.saturatedCast((long)this.containerItem.getBehaviour().getCapacityForResource(ItemVariant.blank()));
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.containerItem.getBehaviour().canInsert(ItemVariant.of(stack));
        }
    }

    public static class BaseHandler<T extends TransferVariant<?>> {
        protected final ItemStack stack;
        protected final ContainerItem<T> containerItem;

        public BaseHandler(ItemStack stack, ContainerItem<T> containerItem) {
            this.stack = stack;
            this.containerItem = containerItem;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public T getResource() {
            return this.containerItem.getResource(this.stack);
        }

        public long getAmount() {
            if (this.isResourceBlank()) {
                return 0L;
            }
            if (!this.containerItem.getBehaviour().isCreative()) {
                return this.containerItem.getAmount(this.stack);
            }
            return Long.MAX_VALUE;
        }

        protected void update(T newResource, long newAmount) {
            this.containerItem.setResourceNoClean(this.stack, newResource);
            this.containerItem.setAmountNoClean(this.stack, newAmount);
            this.containerItem.clean(this.stack);
        }
    }
}

