/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.slf4j.Logger;

public class AggregateDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput packOutput;
    private final String name;
    private final List<DataProvider> providers = new ArrayList<DataProvider>();

    public AggregateDataProvider(PackOutput packOutput, String name) {
        this.packOutput = packOutput;
        this.name = name;
    }

    private <T extends DataProvider> T addProvider(T provider) {
        this.providers.add(provider);
        return provider;
    }

    public <T extends DataProvider> T addProvider(Function<PackOutput, T> providerConstructor) {
        return (T)this.addProvider((DataProvider)providerConstructor.apply(this.packOutput));
    }

    public CompletableFuture<?> run(CachedOutput output) {
        LOGGER.info("Will run the following providers in parallel:" + this.providers.stream().map(provider -> "\n - Modern Industrialization/%s".formatted(provider.getName())).collect(Collectors.joining()));
        return CompletableFuture.allOf((CompletableFuture[])this.providers.stream().map(provider -> provider.run(output)).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return this.name + " (aggregated)";
    }
}

