/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.items.ActivatableItem;
import aztech.modern_industrialization.network.armor.ActivateItemPacket;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.util.Lazy;

public class MIKeybinds {
    private static final Set<Keybind> MAPPINGS = Sets.newHashSet();
    public static final String CATEGORY = Util.makeDescriptionId((String)"key.categories", (ResourceLocation)MI.id("modern_industrialization"));
    public static final Keybind TOGGLE_FLIGHT = MIKeybinds.create("toggle_flight", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, CATEGORY), MIKeybinds.toggleableItemAction(EquipmentSlot.CHEST, i -> i.is((Item)MIItem.DIESEL_JETPACK.asItem()) || i.is((Item)MIItem.GRAVICHESTPLATE.asItem()), (player, activated) -> {}));
    public static final Keybind TOGGLE_3_BY_3 = MIKeybinds.create("toggle_3x3", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 89, CATEGORY), MIKeybinds.toggleableItemAction(EquipmentSlot.MAINHAND, i -> i.is((Item)MIItem.STEAM_MINING_DRILL.asItem()), (player, activated) -> player.displayClientMessage((Component)(activated != false ? MIText.ToolSwitched3x3 : MIText.ToolSwitchedNo3x3).text(), true)));

    public static Set<Keybind> getMappings() {
        return Collections.unmodifiableSet(MAPPINGS);
    }

    public static void init(RegisterKeyMappingsEvent event) {
        MAPPINGS.forEach(m -> event.register((KeyMapping)m.holder().get()));
    }

    private static Keybind create(String id, Function<String, KeyMapping> creator, Runnable action) {
        String descriptionId = Util.makeDescriptionId((String)"key", (ResourceLocation)MI.id(id));
        Keybind keybind = new Keybind((Lazy<KeyMapping>)Lazy.of(() -> (KeyMapping)creator.apply(descriptionId)), action);
        MAPPINGS.add(keybind);
        return keybind;
    }

    private static Runnable toggleableItemAction(EquipmentSlot slot, Predicate<ItemStack> filter, BiConsumer<Player, Boolean> after) {
        return () -> {
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack stack = player.getItemBySlot(slot);
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof ActivatableItem) {
                ActivatableItem item = (ActivatableItem)patt0$temp;
                if (filter.test(stack)) {
                    boolean activated = !item.isActivated(stack);
                    item.setActivated(stack, activated);
                    new ActivateItemPacket(slot, activated).sendToServer();
                    after.accept((Player)player, activated);
                }
            }
        };
    }

    public record Keybind(Lazy<KeyMapping> holder, Runnable action) {
    }
}

