/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.everythingcopper.EverythingCopper;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import cy.jdkdigital.everythingcopper.init.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaxOnRecipe
implements CraftingRecipe {
    public final Ingredient input;
    public final Ingredient wax;

    public WaxOnRecipe(Ingredient input, Ingredient wax) {
        this.input = input;
        this.wax = wax;
    }

    public boolean matches(CraftingInput pInput, Level pLevel) {
        boolean hasWaxItem = false;
        boolean hasWaxableItem = false;
        for (int j = 0; j < pInput.size(); ++j) {
            ItemStack itemStack = pInput.getItem(j);
            if (itemStack.isEmpty()) continue;
            if (itemStack.is(ModTags.WAXING_ITEMS)) {
                hasWaxItem = true;
                continue;
            }
            if (this.input.test(itemStack)) {
                hasWaxableItem = true;
                continue;
            }
            if (itemStack.equals(ItemStack.EMPTY)) continue;
            return false;
        }
        return hasWaxItem && hasWaxableItem;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack outputItem = ItemStack.EMPTY;
        for (int j = 0; j < pInput.size(); ++j) {
            ItemStack itemStack = pInput.getItem(j);
            if (itemStack.isEmpty() || !this.input.test(itemStack)) continue;
            outputItem = itemStack.copy();
        }
        ICopperItem.setWaxed(outputItem, true);
        return outputItem;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.input.getItems().length > 0 ? this.input.getItems()[0] : ItemStack.EMPTY;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        list.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}));
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.WAX_ON.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<WaxOnRecipe> {
        private static final MapCodec<WaxOnRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC.fieldOf("wax").forGetter(recipe -> recipe.input)).apply((Applicative)builder, WaxOnRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WaxOnRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<WaxOnRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaxOnRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static WaxOnRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new WaxOnRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error reading waxing recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, WaxOnRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.wax);
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error writing waxing recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

