/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class OmneticUtil {
    public static void applyOmneticData(PlayerEvent.BreakSpeed e, OmneticData data) {
        float speed = e.getOriginalSpeed();
        for (ItemStack item : data.items()) {
            speed = Math.max(OmneticUtil.getBaseSpeed(e.getEntity(), item, e.getState(), e.getPosition().orElse(BlockPos.ZERO)), speed);
        }
        e.setNewSpeed(Math.max(speed, e.getNewSpeed()));
    }

    public static void applyOmneticData(PlayerEvent.HarvestCheck e, OmneticData data) {
        for (ItemStack item : data.items()) {
            if (!item.isCorrectToolForDrops(e.getTargetBlock())) continue;
            e.setCanHarvest(true);
            break;
        }
    }

    public static float getBaseSpeed(Player player, ItemStack tool, BlockState state, BlockPos pos) {
        float f = tool.getDestroySpeed(state);
        if (f > 1.0f) {
            f += (float)player.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            f *= (switch (player.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        f *= (float)player.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            f *= (float)player.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!player.onGround()) {
            f /= 5.0f;
        }
        return f;
    }

    public record OmneticData(String name, ItemStack[] items) {
        public static Codec<OmneticData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(OmneticData::name), (App)Codec.list((Codec)ItemStack.CODEC).xmap(l -> l.toArray(new ItemStack[0]), Arrays::asList).fieldOf("items").forGetter(OmneticData::items)).apply((Applicative)inst, OmneticData::new));
    }
}

