/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockUtil {
    public static boolean breakExtraBlock(ServerLevel level, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
        FakePlayer player;
        BlockState state = level.getBlockState(pos);
        if (source != null) {
            player = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
            Player realPlayer = level.getPlayerByUUID(source);
            if (realPlayer != null) {
                player.setPos(realPlayer.position());
            }
        } else {
            player = FakePlayerFactory.getMinecraft((ServerLevel)level);
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)mainhand);
        player.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (state.getDestroySpeed((BlockGetter)level, pos) < 0.0f || !state.canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            return false;
        }
        GameType type = player.getAbilities().instabuild ? GameType.CREATIVE : GameType.SURVIVAL;
        BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)type, (ServerPlayer)player, (BlockPos)pos, (BlockState)state);
        if (event.isCanceled()) {
            return false;
        }
        BlockEntity tile = level.getBlockEntity(pos);
        Block block = state.getBlock();
        if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            level.sendBlockUpdated(pos, state, state, 3);
            return false;
        }
        if (player.blockActionRestricted((Level)level, pos, type)) {
            return false;
        }
        BlockState newState = block.playerWillDestroy((Level)level, pos, state, (Player)player);
        if (type.isCreative()) {
            BlockUtil.removeBlock(level, (ServerPlayer)player, pos, newState, false);
            return true;
        }
        ItemStack held = player.getMainHandItem();
        ItemStack heldCopy = held.copy();
        boolean canHarvest = newState.canHarvestBlock((BlockGetter)level, pos, (Player)player);
        held.mineBlock((Level)level, state, pos, (Player)player);
        boolean removed = BlockUtil.removeBlock(level, (ServerPlayer)player, pos, newState, canHarvest);
        if (removed && canHarvest) {
            block.playerDestroy((Level)level, (Player)player, pos, newState, tile, heldCopy);
        }
        if (held.isEmpty() && !heldCopy.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)heldCopy, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        return true;
    }

    public static boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, BlockState state, boolean canHarvest) {
        boolean removed = state.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, level.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return removed;
    }
}

