/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.util.OmneticUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class OmneticBonus
extends GemBonus {
    public static final Codec<OmneticBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(OmneticBonus.gemClass(), (App)Purity.mapCodec(OmneticUtil.OmneticData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OmneticBonus::new));
    protected final Map<Purity, OmneticUtil.OmneticData> values;

    public OmneticBonus(GemClass gemClass, Map<Purity, OmneticUtil.OmneticData> values) {
        super(gemClass);
        this.values = values;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        return Component.translatable((String)"affix.apotheosis:breaker/effect/omnetic.desc", (Object[])new Object[]{Component.translatable((String)("misc.apotheosis." + this.values.get(gem.purity()).name()))}).withStyle(ChatFormatting.YELLOW);
    }

    public static void harvest(PlayerEvent.HarvestCheck e) {
        GemInstance inst;
        ItemStack stack = e.getEntity().getMainHandItem();
        if (!stack.isEmpty() && (inst = (GemInstance)SocketHelper.getGems(stack).streamValidGems().filter(g -> g.getBonus().orElse(null) instanceof OmneticBonus).findFirst().orElse(null)) != null && inst.isValid()) {
            OmneticUtil.OmneticData data = ((OmneticBonus)inst.getBonus().get()).values.get(inst.purity());
            OmneticUtil.applyOmneticData(e, data);
        }
    }

    public static void speed(PlayerEvent.BreakSpeed e) {
        GemInstance inst;
        ItemStack stack = e.getEntity().getMainHandItem();
        if (!stack.isEmpty() && (inst = (GemInstance)SocketHelper.getGems(stack).streamValidGems().filter(g -> g.getBonus().orElse(null) instanceof OmneticBonus).findFirst().orElse(null)) != null && inst.isValid()) {
            OmneticUtil.OmneticData data = ((OmneticBonus)inst.getBonus().get()).values.get(inst.purity());
            OmneticUtil.applyOmneticData(e, data);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, OmneticUtil.OmneticData> values = new LinkedHashMap<Purity, OmneticUtil.OmneticData>();

        public Builder value(Purity rarity, String name, Item ... items) {
            OmneticUtil.OmneticData data = new OmneticUtil.OmneticData(name, (ItemStack[])Arrays.stream(items).map(Item::getDefaultInstance).toArray(ItemStack[]::new));
            this.values.put(rarity, data);
            return this;
        }

        @Override
        public OmneticBonus build(GemClass gClass) {
            return new OmneticBonus(gClass, this.values);
        }
    }
}

