/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class FrozenDropsBonus
extends GemBonus {
    public static Codec<FrozenDropsBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(FrozenDropsBonus.gemClass(), (App)Purity.mapCodec(Codec.floatRange((float)0.0f, (float)100.0f)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, FrozenDropsBonus::new));
    protected final Map<Purity, Float> values;

    public FrozenDropsBonus(GemClass gemClass, Map<Purity, Float> values) {
        super(gemClass);
        this.values = values;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        float value = this.values.get(inst.purity()).floatValue();
        MutableComponent dmgName = Component.translatable((String)((Attribute)ALObjects.Attributes.COLD_DAMAGE.value()).getDescriptionId()).withStyle(ChatFormatting.BLUE);
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{dmgName, Affix.fmt(value * 100.0f)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public void modifyLoot(GemInstance inst, ObjectArrayList<ItemStack> loot, LootContext ctx) {
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity instanceof Mob) {
            float coldDmgTaken;
            Mob mob = (Mob)entity;
            if (ctx.getParamOrNull(LootContextParams.DIRECT_ATTACKING_ENTITY) instanceof ServerPlayer && (coldDmgTaken = ((Float)mob.getData(Apoth.Attachments.COLD_DAMAGE_TAKEN)).floatValue()) / mob.getMaxHealth() >= 0.55f) {
                FrozenDropsBonus.increaseLootDrops(loot, this.values.get(inst.purity()).floatValue(), ctx.getRandom());
            }
        }
    }

    private static void increaseLootDrops(ObjectArrayList<ItemStack> loot, float percent, RandomSource rand) {
        for (int i = 0; i < loot.size(); ++i) {
            int added;
            int newCount;
            ItemStack stack = (ItemStack)loot.get(i);
            int max = stack.getMaxStackSize();
            float target = (float)stack.getCount() * percent;
            if (target - (float)(newCount = (int)target) > 0.001f && rand.nextFloat() <= target - (float)newCount) {
                ++newCount;
            }
            if (stack.getCount() < max) {
                added = Math.min(newCount, max - stack.getCount());
                stack.grow(added);
                newCount -= added;
            }
            while (newCount > 0) {
                added = Math.min(newCount, max);
                ItemStack newStack = stack.copyWithCount(added);
                loot.add(i, (Object)newStack);
                ++i;
                newCount -= added;
            }
        }
    }
}

