/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class DropTransformBonus
extends GemBonus {
    public static Codec<DropTransformBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DropTransformBonus.gemClass(), (App)ContextAwarePredicate.CODEC.fieldOf("conditions").forGetter(a -> a.conditions), (App)Ingredient.CODEC_NONEMPTY.fieldOf("inputs").forGetter(a -> a.inputs), (App)ItemStack.CODEC.fieldOf("output").forGetter(a -> a.output), (App)Purity.mapCodec(Codec.floatRange((float)0.0f, (float)1.0f)).fieldOf("values").forGetter(a -> a.values), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.descKey)).apply((Applicative)inst, DropTransformBonus::new));
    protected final ContextAwarePredicate conditions;
    protected final Ingredient inputs;
    protected final ItemStack output;
    protected final Map<Purity, Float> values;
    protected final String descKey;

    public DropTransformBonus(GemClass gemClass, ContextAwarePredicate conditions, Ingredient inputs, ItemStack output, Map<Purity, Float> values, String descKey) {
        super(gemClass);
        this.conditions = conditions;
        this.inputs = inputs;
        this.output = output;
        this.values = values;
        this.descKey = descKey;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        float chance = this.values.get(inst.purity()).floatValue();
        return Component.translatable((String)this.descKey, (Object[])new Object[]{Affix.fmt(chance * 100.0f)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public void modifyLoot(GemInstance inst, ObjectArrayList<ItemStack> loot, LootContext ctx) {
        if (this.conditions.matches(ctx) && ctx.getRandom().nextFloat() <= this.values.get(inst.purity()).floatValue()) {
            for (int i = 0; i < loot.size(); ++i) {
                ItemStack stack = (ItemStack)loot.get(i);
                if (!this.inputs.test(stack)) continue;
                ItemStack outCopy = this.output.copy();
                outCopy.setCount(stack.getCount());
                loot.set(i, (Object)outCopy);
            }
        }
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final List<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
        private final Map<Purity, Float> values = new HashMap<Purity, Float>();
        private Ingredient inputs;
        private ItemStack output;
        private String descKey;

        public Builder condition(LootItemCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder inputs(Ingredient inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder output(ItemStack output) {
            this.output = output.copy();
            return this;
        }

        public Builder value(Purity purity, float chance) {
            if (chance < 0.0f || chance > 1.0f) {
                throw new IllegalArgumentException("Chance must be between 0 and 1");
            }
            this.values.put(purity, Float.valueOf(chance));
            return this;
        }

        public Builder desc(String descKey) {
            this.descKey = descKey;
            return this;
        }

        @Override
        public DropTransformBonus build(GemClass gemClass) {
            ContextAwarePredicate predicate = ContextAwarePredicate.create((LootItemCondition[])this.conditions.toArray(new LootItemCondition[0]));
            return new DropTransformBonus(gemClass, predicate, this.inputs, this.output, this.values, this.descKey);
        }
    }
}

