/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apothic_enchanting.Ench;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class BloodyArrowBonus
extends GemBonus {
    public static Codec<BloodyArrowBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Purity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, BloodyArrowBonus::new));
    protected final Map<Purity, Data> values;

    public BloodyArrowBonus(Map<Purity, Data> values) {
        super(new GemClass(Apoth.LootCategories.BOW));
        this.values = values;
    }

    @Override
    public void onProjectileFired(GemInstance inst, LivingEntity user, Projectile proj) {
        if (proj instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)proj;
            Data d = this.values.get(inst.purity());
            if (Affix.isOnCooldown(BloodyArrowBonus.makeUniqueId(inst), d.cooldown, user)) {
                return;
            }
            user.hurt(user.damageSources().source(Ench.DamageTypes.CORRUPTED), user.getMaxHealth() * d.healthCost);
            arrow.setBaseDamage(arrow.getBaseDamage() * (double)d.dmgMultiplier);
            Affix.startCooldown(BloodyArrowBonus.makeUniqueId(inst), user);
        }
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        Data d = this.values.get(inst.purity());
        MutableComponent cooldown = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)d.cooldown, (float)ctx.tickRate())});
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(d.healthCost * 100.0f), Affix.fmt(100.0f * d.dmgMultiplier), cooldown}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public record Data(float healthCost, float dmgMultiplier, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("health_cost").forGetter(Data::healthCost), (App)Codec.FLOAT.fieldOf("damage_mult").forGetter(Data::dmgMultiplier), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }
}

