/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.UnsocketedGem;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.Nullable;

public class GemItem
extends Item
implements ITabFiller {
    public static final String HAS_REFRESHED = "has_refreshed";
    public static final String UUID_ARRAY = "uuids";
    public static final String GEM = "gem";

    public GemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        UnsocketedGem inst = UnsocketedGem.of(stack);
        if (!inst.isValid()) {
            tooltip.add((Component)Component.literal((String)"Errored gem with no bonus!").withStyle(ChatFormatting.GRAY));
            return;
        }
        inst.addInformation(tooltip::add, AttributeTooltipContext.of((Player)ApothMiscUtil.getClientPlayer(), (Item.TooltipContext)ctx, (TooltipFlag)flag));
    }

    public Component getName(ItemStack pStack) {
        UnsocketedGem inst = UnsocketedGem.of(pStack);
        if (!inst.isValid()) {
            return super.getName(pStack);
        }
        MutableComponent comp = Component.translatable((String)this.getDescriptionId(pStack));
        comp = Component.translatable((String)("item.apotheosis.gem." + inst.purity().getSerializedName()), (Object[])new Object[]{comp});
        return comp.withStyle(Style.EMPTY.withColor(inst.purity().getColor()));
    }

    public String getDescriptionId(ItemStack pStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(pStack);
        if (!gem.isBound()) {
            return super.getDescriptionId();
        }
        return super.getDescriptionId(pStack) + "." + String.valueOf(gem.getId());
    }

    public boolean isFoil(ItemStack pStack) {
        UnsocketedGem inst = UnsocketedGem.of(pStack);
        return inst.isValid() && inst.isPerfect();
    }

    public boolean canBeHurtBy(ItemStack stack, DamageSource src) {
        return super.canBeHurtBy(stack, src) && !src.is(DamageTypes.FALLING_ANVIL);
    }

    public void fillItemCategory(CreativeModeTab group, BuildCreativeModeTabContentsEvent out) {
        GemRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gem::getId)).forEach(gem -> Arrays.stream(Purity.values()).forEach(purity -> {
            if (purity.isAtLeast(gem.getMinPurity())) {
                ItemStack stack = new ItemStack((ItemLike)this);
                GemItem.setGem(stack, gem);
                GemItem.setPurity(stack, purity);
                out.accept(stack);
            }
        }));
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        UnsocketedGem inst = UnsocketedGem.of(stack);
        if (inst.isValid()) {
            return inst.gem().getId().getNamespace();
        }
        return super.getCreatorModId(stack);
    }

    public static DynamicHolder<Gem> getGem(ItemStack gem) {
        return (DynamicHolder)gem.getOrDefault(Apoth.Components.GEM, (Object)GemRegistry.INSTANCE.emptyHolder());
    }

    public static void setGem(ItemStack gemStack, Gem gem) {
        gemStack.set(Apoth.Components.GEM, (Object)GemRegistry.INSTANCE.holder(gem));
    }

    public static Purity getPurity(ItemStack stack) {
        return (Purity)stack.getOrDefault(Apoth.Components.PURITY, (Object)Purity.CRACKED);
    }

    public static void setPurity(ItemStack stack, Purity purity) {
        stack.set(Apoth.Components.PURITY, (Object)purity);
    }
}

