/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;

public record GemClass(String key, HolderSet<LootCategory> types) {
    public static Codec<GemClass> EXPLICIT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("key").forGetter(GemClass::key), (App)RegistryCodecs.homogeneousList((ResourceKey)Apoth.BuiltInRegs.LOOT_CATEGORY.key()).fieldOf("types").forGetter(GemClass::types)).apply((Applicative)inst, GemClass::new));
    public static Codec<GemClass> CODEC = Codec.either(EXPLICIT_CODEC, LootCategory.CODEC).xmap(e -> (GemClass)e.map(Function.identity(), GemClass::new), GemClass::toEither);

    public GemClass(LootCategory category) {
        this(category.getKey().getPath(), category);
    }

    public GemClass(String key, LootCategory ... types) {
        this(key, (HolderSet<LootCategory>)HolderSet.direct(Arrays.stream(types).map(arg_0 -> Apoth.BuiltInRegs.LOOT_CATEGORY.wrapAsHolder(arg_0)).toList()));
    }

    public GemClass(String key, HolderSet<LootCategory> types) {
        this.key = key;
        this.types = types;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Invalid GemClass with null key");
        Preconditions.checkArgument((this.types != null && this.types.size() > 0 ? 1 : 0) != 0, (Object)"Invalid GemClass with null or empty types");
    }

    private static Either<GemClass, LootCategory> toEither(GemClass gc) {
        if (gc.types.size() == 1) {
            return Either.right((Object)((LootCategory)((Holder)gc.types.iterator().next()).value()));
        }
        return Either.left((Object)gc);
    }
}

