/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class SpawnCooldownSavedData
extends SavedData {
    public Object2IntMap<ResourceLocation> bossCooldowns = new Object2IntOpenHashMap();

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        for (Object2IntMap.Entry e : this.bossCooldowns.object2IntEntrySet()) {
            tag.putInt(((ResourceLocation)e.getKey()).toString(), e.getIntValue());
        }
        return tag;
    }

    public void tick(ResourceLocation level) {
        this.bossCooldowns.computeIntIfPresent((Object)level, (key, value) -> Math.max(0, value - 1));
    }

    public boolean isOnCooldown(Level level) {
        return this.isOnCooldown(level.dimension().location());
    }

    public boolean isOnCooldown(ResourceLocation level) {
        return this.bossCooldowns.getInt((Object)level) > 0;
    }

    public void startCooldown(Level level, int timer) {
        this.startCooldown(level.dimension().location(), timer);
    }

    public void startCooldown(ResourceLocation level, int timer) {
        this.bossCooldowns.put((Object)level, timer);
    }

    public static SpawnCooldownSavedData loadTimes(CompoundTag tag, HolderLookup.Provider registries) {
        SpawnCooldownSavedData data = new SpawnCooldownSavedData();
        data.bossCooldowns.clear();
        for (String s : tag.getAllKeys()) {
            ResourceLocation id = ResourceLocation.tryParse((String)s);
            if (id == null) continue;
            int val = tag.getInt(s);
            data.bossCooldowns.put((Object)id, val);
        }
        return data;
    }
}

