/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityOverride;
import dev.shadowsoffire.apotheosis.loot.RarityOverrideRegistry;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.loot.RarityRenderData;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public record LootRarity(TextColor color, Holder<Item> material, TieredWeights weights, List<LootRule> rules, int sortIndex, RarityRenderData renderData) implements CodecProvider<LootRarity>,
TieredWeights.Weighted
{
    public static final Codec<LootRarity> LOAD_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextColor.CODEC.fieldOf("color").forGetter(LootRarity::color), (App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("material").forGetter(LootRarity::material), (App)TieredWeights.CODEC.fieldOf("weights").forGetter(TieredWeights.Weighted::weights), (App)LootRule.CODEC.listOf().fieldOf("rules").forGetter(LootRarity::rules), (App)Codec.intRange((int)0, (int)2000).optionalFieldOf("sort_index", (Object)1000).forGetter(LootRarity::sortIndex), (App)RarityRenderData.CODEC.optionalFieldOf("render_data", (Object)RarityRenderData.DEFAULT).forGetter(LootRarity::renderData)).apply((Applicative)inst, LootRarity::new));
    public static final Codec<LootRarity> CODEC = Codec.lazyInitialized(() -> RarityRegistry.INSTANCE.holderCodec().xmap(DynamicHolder::get, arg_0 -> ((RarityRegistry)RarityRegistry.INSTANCE).holder(arg_0)));

    public Item getMaterial() {
        return (Item)this.material.value();
    }

    public List<LootRule> getRules(LootCategory category) {
        RarityOverride overrides = RarityOverrideRegistry.INSTANCE.getOverride(category);
        if (overrides != null && overrides.hasRules(this)) {
            return overrides.getRules(this);
        }
        return this.rules;
    }

    public MutableComponent toComponent() {
        return Component.translatable((String)("rarity." + String.valueOf(RarityRegistry.INSTANCE.getKey(this)))).withStyle(Style.EMPTY.withColor(this.color));
    }

    @Override
    public String toString() {
        return "LootRarity{" + String.valueOf(RarityRegistry.INSTANCE.getKey(this)) + "}";
    }

    public Codec<LootRarity> getCodec() {
        return LOAD_CODEC;
    }

    @Nullable
    public static LootRarity random(GenContext ctx) {
        return (LootRarity)RarityRegistry.INSTANCE.getRandomItem(ctx);
    }

    public static LootRarity random(GenContext ctx, Set<LootRarity> pool) {
        return RarityRegistry.INSTANCE.getRandomItem(ctx, pool);
    }

    public static LootRarity randomFromHolders(GenContext ctx, Set<DynamicHolder<LootRarity>> pool) {
        return (LootRarity)RarityRegistry.INSTANCE.getRandomItemFromHolders(ctx, pool);
    }

    public static <T> Codec<Map<LootRarity, T>> mapCodec(Codec<T> codec) {
        return Codec.unboundedMap(CODEC, codec);
    }

    public static Builder builder(TextColor color, Holder<Item> material) {
        return new Builder(color, material);
    }

    public static class Builder {
        private final TextColor color;
        private final Holder<Item> material;
        private TieredWeights weights;
        private final List<LootRule> rules = new ArrayList<LootRule>();
        private int index = 1000;
        private RarityRenderData renderData = RarityRenderData.DEFAULT;

        public Builder(TextColor color, Holder<Item> material) {
            this.color = color;
            this.material = material;
        }

        public Builder weights(TieredWeights.Builder builder) {
            this.weights = builder.build();
            return this;
        }

        public Builder rule(LootRule rule) {
            this.rules.add(rule);
            return this;
        }

        public Builder sortIndex(int index) {
            this.index = index;
            return this;
        }

        public Builder renderData(UnaryOperator<RarityRenderData.Builder> config) {
            this.renderData = ((RarityRenderData.Builder)config.apply(new RarityRenderData.Builder())).build();
            return this;
        }

        public LootRarity build() {
            Preconditions.checkNotNull((Object)this.weights);
            Preconditions.checkArgument((this.rules.size() > 0 ? 1 : 0) != 0);
            return new LootRarity(this.color, this.material, this.weights, this.rules, this.index, this.renderData);
        }
    }
}

