/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data.twilight;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.init.TFArmorMaterials;
import twilightforest.init.TFItems;
import twilightforest.util.TFToolMaterials;

public class TwilightAffixLootProvider
extends AffixLootEntryProvider {
    protected static final TieredWeights IRONWOOD = TieredWeights.builder().with(WorldTier.FRONTIER, 25, 1.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights STEELEAF = TieredWeights.builder().with(WorldTier.FRONTIER, 25, 1.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights KNIGHTMETAL = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 25, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights ARCTIC_FIERY = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 25, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights YETI = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 1.0f).with(WorldTier.PINNACLE, 25, 2.0f).build();
    protected static final TieredWeights BOWS = TieredWeights.builder().with(WorldTier.SUMMIT, 7, 1.0f).with(WorldTier.PINNACLE, 7, 1.0f).build();

    public TwilightAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @Override
    public String getName() {
        return "Twilight Affix Loot Entries";
    }

    @Override
    public void generate() {
        HashMap<DeferredHolder, TieredWeights> armorWeights = new HashMap<DeferredHolder, TieredWeights>();
        armorWeights.put(TFArmorMaterials.IRONWOOD, IRONWOOD);
        armorWeights.put(TFArmorMaterials.STEELEAF, STEELEAF);
        armorWeights.put(TFArmorMaterials.KNIGHTMETAL, KNIGHTMETAL);
        armorWeights.put(TFArmorMaterials.ARCTIC, ARCTIC_FIERY);
        armorWeights.put(TFArmorMaterials.FIERY, ARCTIC_FIERY);
        armorWeights.put(TFArmorMaterials.YETI, YETI);
        HashMap<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
        toolWeights.put(TFToolMaterials.IRONWOOD, IRONWOOD);
        toolWeights.put(TFToolMaterials.STEELEAF, STEELEAF);
        toolWeights.put(TFToolMaterials.KNIGHTMETAL, KNIGHTMETAL);
        toolWeights.put(TFToolMaterials.ICE, ARCTIC_FIERY);
        toolWeights.put(TFToolMaterials.FIERY, ARCTIC_FIERY);
        toolWeights.put(TFToolMaterials.GIANT, YETI);
        toolWeights.put(TFToolMaterials.GLASS, YETI);
        for (Item i : BuiltInRegistries.ITEM) {
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!"twilightforest".equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem(i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                weights = (TieredWeights)toolWeights.get(t.getTier());
                if (weights == null) continue;
                this.addEntry(new AffixLootEntry(weights, new ItemStack((ItemLike)i)));
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = (TieredWeights)armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(new AffixLootEntry(weights, new ItemStack((ItemLike)i)));
        }
        this.addEntry(new AffixLootEntry(BOWS, new ItemStack((ItemLike)TFItems.ENDER_BOW.get())));
        this.addEntry(new AffixLootEntry(BOWS, new ItemStack((ItemLike)TFItems.ICE_BOW.get())));
        this.addEntry(new AffixLootEntry(BOWS, new ItemStack((ItemLike)TFItems.SEEKER_BOW.get())));
        this.addEntry(new AffixLootEntry(BOWS, new ItemStack((ItemLike)TFItems.TRIPLE_BOW.get())));
        this.addEntry(new AffixLootEntry(TieredWeights.forTiersAbove(WorldTier.ASCENT, 5, 1.0f), new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SHIELD.get())));
    }

    @Override
    protected void addEntry(AffixLootEntry entry) {
        ResourceLocation key = Apotheosis.loc("twilight/" + BuiltInRegistries.ITEM.getKey((Object)entry.stack().getItem()).getPath());
        this.addConditionally(key, entry, new ICondition[]{new ModLoadedCondition("twilightforest")});
    }
}

