/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.WeightedItemStack;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.util.random.Weight;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;

public class GearSetProvider
extends DynamicRegistryProvider<GearSet> {
    public static final int DEFAULT_WEIGHT = 100;

    public GearSetProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)GearSetRegistry.INSTANCE);
    }

    public String getName() {
        return "Gear Sets";
    }

    public void generate() {
        HolderLookup.Provider registries = (HolderLookup.Provider)this.lookupProvider.join();
        HolderLookup.RegistryLookup enchants = (HolderLookup.RegistryLookup)registries.lookup(Registries.ENCHANTMENT).get();
        this.addSet("haven/leather", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.STONE_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.STONE_AXE), 10).mainhand(new ItemStack((ItemLike)Items.STONE_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.STONE_SHOVEL), 10).helmet(new ItemStack((ItemLike)Items.LEATHER_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.LEATHER_BOOTS), 10).tag("haven_melee"));
        this.addSet("haven/ranged/leather", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 16).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 4).helmet(new ItemStack((ItemLike)Items.LEATHER_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.LEATHER_BOOTS), 10).tag("haven_ranged"));
        this.addSet("haven/chain", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.STONE_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.STONE_AXE), 10).mainhand(new ItemStack((ItemLike)Items.STONE_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.STONE_SHOVEL), 10).helmet(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), 10).tag("haven_melee"));
        this.addSet("haven/ranged/chain", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 16).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 4).helmet(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), 10).tag("haven_ranged"));
        this.addSet("frontier/chain", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.IRON_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.IRON_AXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_SHOVEL), 10).helmet(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), 10).tag("frontier_melee"));
        this.addSet("frontier/ranged/chain", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 16).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 4).helmet(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), 10).tag("frontier_ranged"));
        this.addSet("frontier/iron", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.IRON_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.IRON_AXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.IRON_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.IRON_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.IRON_BOOTS), 10).tag("frontier_melee"));
        this.addSet("frontier/ranged/iron", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 16).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 4).helmet(new ItemStack((ItemLike)Items.IRON_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.IRON_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.IRON_BOOTS), 10).tag("frontier_ranged"));
        this.addSet("frontier/diamond", 10, 2.5f, c -> c.mainhand(new ItemStack((ItemLike)Items.DIAMOND_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_AXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.DIAMOND_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), 10).tag("frontier_melee"));
        this.addSet("ascent/enchanted_gold", 100, 0.0f, c -> c.mainhand(GearSetProvider.buffedGoldItem(Items.GOLDEN_SWORD, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).mainhand(GearSetProvider.buffedGoldItem(Items.GOLDEN_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).mainhand(GearSetProvider.buffedGoldItem(Items.GOLDEN_PICKAXE, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).mainhand(GearSetProvider.buffedGoldItem(Items.GOLDEN_SHOVEL, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).helmet(GearSetProvider.buffedGoldItem(Items.GOLDEN_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).chestplate(GearSetProvider.buffedGoldItem(Items.GOLDEN_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).leggings(GearSetProvider.buffedGoldItem(Items.GOLDEN_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).boots(GearSetProvider.buffedGoldItem(Items.GOLDEN_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).tag("ascent_melee"));
        this.addSet("ascent/ranged/enchanted_gold", 100, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 12).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 8).helmet(GearSetProvider.buffedGoldItem(Items.GOLDEN_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).chestplate(GearSetProvider.buffedGoldItem(Items.GOLDEN_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).leggings(GearSetProvider.buffedGoldItem(Items.GOLDEN_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).boots(GearSetProvider.buffedGoldItem(Items.GOLDEN_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants), 10).tag("ascent_ranged"));
        this.addSet("ascent/iron", 80, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.IRON_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.IRON_AXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.IRON_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.IRON_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.IRON_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.IRON_BOOTS), 10).tag("ascent_melee"));
        this.addSet("ascent/ranged/iron", 80, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 12).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 8).helmet(new ItemStack((ItemLike)Items.IRON_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.IRON_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.IRON_BOOTS), 10).tag("ascent_ranged"));
        this.addSet("ascent/diamond", 100, 5.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.DIAMOND_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_AXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.DIAMOND_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), 10).tag("ascent_melee"));
        this.addSet("ascent/ranged/diamond", 100, 5.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 12).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 8).helmet(new ItemStack((ItemLike)Items.DIAMOND_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), 10).tag("ascent_ranged"));
        this.addSet("summit/enchanted_iron", 30, 0.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.IRON_SWORD, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).mainhand(GearSetProvider.buffedItem(Items.IRON_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).mainhand(GearSetProvider.buffedItem(Items.IRON_PICKAXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).mainhand(GearSetProvider.buffedItem(Items.IRON_SHOVEL, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).helmet(GearSetProvider.buffedItem(Items.IRON_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).chestplate(GearSetProvider.buffedItem(Items.IRON_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).leggings(GearSetProvider.buffedItem(Items.IRON_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).boots(GearSetProvider.buffedItem(Items.IRON_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).tag("summit_melee"));
        this.addSet("summit/ranged/enchanted_iron", 30, 0.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.BOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).mainhand(GearSetProvider.buffedItem(Items.CROSSBOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).helmet(GearSetProvider.buffedItem(Items.IRON_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).chestplate(GearSetProvider.buffedItem(Items.IRON_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).leggings(GearSetProvider.buffedItem(Items.IRON_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).boots(GearSetProvider.buffedItem(Items.IRON_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).tag("summit_ranged"));
        this.addSet("summit/diamond", 40, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.DIAMOND_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_AXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.DIAMOND_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), 10).tag("summit_melee"));
        this.addSet("summit/ranged/diamond", 40, 0.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 10).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 10).helmet(new ItemStack((ItemLike)Items.DIAMOND_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), 10).tag("summit_ranged"));
        this.addSet("summit/enchanted_diamond", 60, 0.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.DIAMOND_SWORD, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.5f), 10).mainhand(GearSetProvider.buffedItem(Items.DIAMOND_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.5f), 10).mainhand(GearSetProvider.buffedItem(Items.DIAMOND_PICKAXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.5f), 10).mainhand(GearSetProvider.buffedItem(Items.DIAMOND_SHOVEL, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.5f), 10).helmet(GearSetProvider.buffedItem(Items.DIAMOND_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).chestplate(GearSetProvider.buffedItem(Items.DIAMOND_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).leggings(GearSetProvider.buffedItem(Items.DIAMOND_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).boots(GearSetProvider.buffedItem(Items.DIAMOND_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.0f), 10).tag("summit_melee"));
        this.addSet("summit/ranged/enchanted_diamond", 100, 0.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.BOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.2f), 10).mainhand(GearSetProvider.buffedItem(Items.CROSSBOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 1.2f), 10).helmet(GearSetProvider.buffedItem(Items.DIAMOND_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.6f), 10).chestplate(GearSetProvider.buffedItem(Items.DIAMOND_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.6f), 10).leggings(GearSetProvider.buffedItem(Items.DIAMOND_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.6f), 10).boots(GearSetProvider.buffedItem(Items.DIAMOND_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.6f), 10).tag("summit_ranged"));
        this.addSet("summit/netherite", 140, 5.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.NETHERITE_SWORD), 10).mainhand(new ItemStack((ItemLike)Items.NETHERITE_AXE), 10).mainhand(new ItemStack((ItemLike)Items.NETHERITE_PICKAXE), 10).mainhand(new ItemStack((ItemLike)Items.NETHERITE_SHOVEL), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(new ItemStack((ItemLike)Items.NETHERITE_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.NETHERITE_BOOTS), 10).tag("summit_melee"));
        this.addSet("summit/ranged/netherite", 140, 5.0f, c -> c.mainhand(new ItemStack((ItemLike)Items.BOW), 10).mainhand(new ItemStack((ItemLike)Items.CROSSBOW), 10).helmet(new ItemStack((ItemLike)Items.NETHERITE_HELMET), 10).chestplate(new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE), 10).leggings(new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), 10).boots(new ItemStack((ItemLike)Items.NETHERITE_BOOTS), 10).tag("summit_ranged"));
        this.addSet("pinnacle/enchanted_netherite", 100, 5.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.NETHERITE_SWORD, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).mainhand(GearSetProvider.buffedItem(Items.NETHERITE_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).mainhand(GearSetProvider.buffedItem(Items.NETHERITE_PICKAXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).mainhand(GearSetProvider.buffedItem(Items.NETHERITE_SHOVEL, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).offhand(new ItemStack((ItemLike)Items.SHIELD), 10).helmet(GearSetProvider.buffedItem(Items.NETHERITE_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).chestplate(GearSetProvider.buffedItem(Items.NETHERITE_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).leggings(GearSetProvider.buffedItem(Items.NETHERITE_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).boots(GearSetProvider.buffedItem(Items.NETHERITE_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).tag("pinnacle_melee"));
        this.addSet("pinnacle/ranged/enchanted_netherite", 100, 5.0f, c -> c.mainhand(GearSetProvider.buffedItem(Items.BOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).mainhand(GearSetProvider.buffedItem(Items.CROSSBOW, (HolderLookup.RegistryLookup<Enchantment>)enchants, 3.0f), 10).helmet(GearSetProvider.buffedItem(Items.NETHERITE_HELMET, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).chestplate(GearSetProvider.buffedItem(Items.NETHERITE_CHESTPLATE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).leggings(GearSetProvider.buffedItem(Items.NETHERITE_LEGGINGS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).boots(GearSetProvider.buffedItem(Items.NETHERITE_BOOTS, (HolderLookup.RegistryLookup<Enchantment>)enchants, 2.0f), 10).tag("pinnacle_ranged"));
        this.addSet("gateway_only/nether_herald", 0, 0.0f, c -> c.helmet(GearSetProvider.getNetherHeraldBannerInstance((HolderGetter<BannerPattern>)registries.lookupOrThrow(Registries.BANNER_PATTERN)), 1).mainhand(GearSetProvider.buffedItem(Items.DIAMOND_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.5f), 1));
        this.addSet("gateway_only/bastion_guard", 0, 0.0f, c -> c.helmet(GearSetProvider.getBastionGuardBannerInstance((HolderGetter<BannerPattern>)registries.lookupOrThrow(Registries.BANNER_PATTERN)), 1).mainhand(GearSetProvider.buffedItem(Items.NETHERITE_AXE, (HolderLookup.RegistryLookup<Enchantment>)enchants, 0.5f), 1).offhand(new ItemStack((ItemLike)Items.SHIELD), 1).chestplate(new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE), 1).leggings(new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), 1).boots(new ItemStack((ItemLike)Items.NETHERITE_BOOTS), 1));
    }

    protected static ItemStack buffedItem(Item item, HolderLookup.RegistryLookup<Enchantment> enchants, float magnitude) {
        ItemStack stack = new ItemStack((ItemLike)item);
        LootCategory cat = LootCategory.forItem(stack);
        stack.set(Apoth.Components.DURABILITY_BONUS, (Object)Float.valueOf(Mth.clamp((float)(0.35f * magnitude), (float)0.0f, (float)0.8f)));
        if (cat.isArmor()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.PROTECTION), Mth.ceil((float)(magnitude * 3.0f)));
        } else if (cat.isMelee()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.SHARPNESS), Mth.ceil((float)(magnitude * 5.0f)));
        } else if (cat.isBreaker()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.FORTUNE), Mth.ceil((float)(magnitude * 5.0f)));
        } else if (cat.isRanged()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.POWER), Mth.ceil((float)(magnitude * 5.0f)));
        }
        return stack;
    }

    protected static ItemStack buffedGoldItem(Item item, HolderLookup.RegistryLookup<Enchantment> enchants) {
        ItemStack stack = new ItemStack((ItemLike)item);
        LootCategory cat = LootCategory.forItem(stack);
        stack.set(Apoth.Components.DURABILITY_BONUS, (Object)Float.valueOf(0.5f));
        if (cat.isArmor()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.PROTECTION), 3);
        } else if (cat.isMelee()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.SHARPNESS), 5);
        } else if (cat.isBreaker()) {
            stack.enchant((Holder)enchants.getOrThrow(Enchantments.FORTUNE), 5);
        }
        return stack;
    }

    public static ItemStack getNetherHeraldBannerInstance(HolderGetter<BannerPattern> patternRegistry) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.BLACK_BANNER);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.Builder().addIfRegistered(patternRegistry, BannerPatterns.SKULL, DyeColor.YELLOW).addIfRegistered(patternRegistry, BannerPatterns.BORDER, DyeColor.RED).addIfRegistered(patternRegistry, BannerPatterns.GRADIENT_UP, DyeColor.BLACK).build();
        itemstack.set(DataComponents.BANNER_PATTERNS, (Object)bannerpatternlayers);
        itemstack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        itemstack.set(DataComponents.ITEM_NAME, (Object)Apotheosis.lang("banner", "nether_herald", new Object[0]).withStyle(ChatFormatting.RED));
        return itemstack;
    }

    public static ItemStack getBastionGuardBannerInstance(HolderGetter<BannerPattern> patternRegistry) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.BROWN_BANNER);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.Builder().addIfRegistered(patternRegistry, BannerPatterns.CIRCLE_MIDDLE, DyeColor.BLACK).addIfRegistered(patternRegistry, BannerPatterns.CURLY_BORDER, DyeColor.YELLOW).build();
        itemstack.set(DataComponents.BANNER_PATTERNS, (Object)bannerpatternlayers);
        itemstack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        itemstack.set(DataComponents.ITEM_NAME, (Object)Apotheosis.lang("banner", "bastion_guard", new Object[0]).withStyle(ChatFormatting.RED));
        return itemstack;
    }

    protected void addSet(String name, int weight, float quality, UnaryOperator<GSBuilder> config) {
        this.add(Apotheosis.loc(name), (CodecProvider)((GSBuilder)config.apply(new GSBuilder(weight, quality))).build());
    }

    public static class GSBuilder {
        private final int weight;
        private final float quality;
        private final List<WeightedItemStack> helmets = new ArrayList<WeightedItemStack>();
        private final List<WeightedItemStack> chestplates = new ArrayList<WeightedItemStack>();
        private final List<WeightedItemStack> leggings = new ArrayList<WeightedItemStack>();
        private final List<WeightedItemStack> boots = new ArrayList<WeightedItemStack>();
        private final List<WeightedItemStack> mainhands = new ArrayList<WeightedItemStack>();
        private final List<WeightedItemStack> offhands = new ArrayList<WeightedItemStack>();
        private final Set<String> tags = new LinkedHashSet<String>();

        public GSBuilder(int weight, float quality) {
            this.weight = weight;
            this.quality = quality;
        }

        public GSBuilder helmet(ItemStack stack, int weight, float dropChance) {
            this.helmets.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder helmet(ItemStack stack, int weight) {
            return this.helmet(stack, weight, -1.0f);
        }

        public GSBuilder chestplate(ItemStack stack, int weight, float dropChance) {
            this.chestplates.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder chestplate(ItemStack stack, int weight) {
            return this.chestplate(stack, weight, -1.0f);
        }

        public GSBuilder leggings(ItemStack stack, int weight, float dropChance) {
            this.leggings.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder leggings(ItemStack stack, int weight) {
            return this.leggings(stack, weight, -1.0f);
        }

        public GSBuilder boots(ItemStack stack, int weight, float dropChance) {
            this.boots.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder boots(ItemStack stack, int weight) {
            return this.boots(stack, weight, -1.0f);
        }

        public GSBuilder mainhand(ItemStack stack, int weight, float dropChance) {
            this.mainhands.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder mainhand(ItemStack stack, int weight) {
            return this.mainhand(stack, weight, -1.0f);
        }

        public GSBuilder offhand(ItemStack stack, int weight, float dropChance) {
            this.offhands.add(new WeightedItemStack(stack, Weight.of((int)weight), dropChance));
            return this;
        }

        public GSBuilder offhand(ItemStack stack, int weight) {
            return this.offhand(stack, weight, -1.0f);
        }

        public GSBuilder tag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public GearSet build() {
            return new GearSet(this.weight, this.quality, this.mainhands, this.offhands, this.boots, this.leggings, this.chestplates, this.helmets, this.tags);
        }
    }
}

