/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.apotheosis.compat.gateways.GatewaysCompat;
import dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate.TieredGateway;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TieredGatewayEntity
extends GatewayEntity {
    public TieredGatewayEntity(Level level, Player placer, DynamicHolder<Gateway> gate) {
        super(GatewaysCompat.TIERED_GATEWAY.get(), level, placer, gate);
        this.summonerId = placer.getUUID();
        this.gate = gate;
        Preconditions.checkArgument((boolean)gate.isBound(), (Object)"A gateway may not be constructed for an unbound holder.");
        this.setCustomName((Component)Component.translatable((String)gate.getId().toString().replace(':', '.')).withStyle(Style.EMPTY.withColor(((Gateway)gate.get()).color())));
        this.bossEvent = this.createBossEvent();
        this.refreshDimensions();
    }

    public TieredGatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public boolean isLastWave() {
        return this.getWave() >= this.getGateway().getNumWaves();
    }

    public Wave getCurrentWave() {
        return this.getGateway().getWave(Math.min(this.getGateway().getNumWaves() - 1, this.getWave()));
    }

    protected boolean canStartNextWave() {
        return super.canStartNextWave() && !this.isLastWave();
    }

    public boolean isCompleted() {
        return this.undroppedItems.isEmpty() && this.isLastWave();
    }

    protected void completeWave() {
        Player player = this.summonerOrClosest();
        this.undroppedItems.addAll(this.getCurrentWave().spawnRewards((ServerLevel)this.level(), (GatewayEntity)this, player));
    }

    protected void completeGateway() {
        super.completeGateway();
        Player player = this.summonerOrClosest();
        this.getGateway().rewards().forEach(r -> r.generateLoot((ServerLevel)this.level(), (GatewayEntity)this, player, arg_0 -> ((TieredGatewayEntity)this).spawnCompletionItem(arg_0)));
    }

    public TieredGateway getGateway() {
        return (TieredGateway)super.getGateway();
    }
}

