/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.salvaging;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingMenu;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.client.GrayBufferSource;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class SalvagingScreen
extends AdventureContainerScreen<SalvagingMenu> {
    public static final Component TITLE = Component.translatable((String)"container.apotheosis.salvage");
    public static final ResourceLocation TEXTURE = Apotheosis.loc("textures/gui/salvage.png");
    protected List<SalvagingRecipe.OutputData> results = new ArrayList<SalvagingRecipe.OutputData>();
    protected SimpleTexButton salvageBtn;

    public SalvagingScreen(SalvagingMenu menu, Inventory inv, Component title) {
        super(menu, inv, TITLE);
        ((SalvagingMenu)this.menu).addSlotListener((id, stack) -> this.computeResults());
        this.imageHeight = 174;
    }

    protected void init() {
        super.init();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.salvageBtn = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)new SimpleTexButton(left + 98, top + 34, 18, 18, 238, 0, TEXTURE, 256, 256, btn -> this.minecraft.gameMode.handleInventoryButtonClick(((SalvagingMenu)this.menu).containerId, 0), (Component)Component.translatable((String)"button.apotheosis.salvage")).setInactiveMessage((Component)Component.translatable((String)"button.apotheosis.no_salvage").withStyle(ChatFormatting.RED)));
        this.computeResults();
    }

    public void computeResults() {
        if (this.salvageBtn == null) {
            return;
        }
        ArrayList<SalvagingRecipe.OutputData> matches = new ArrayList<SalvagingRecipe.OutputData>();
        for (int i = 0; i < 15; ++i) {
            Slot s = ((SalvagingMenu)this.menu).getSlot(i);
            ItemStack stack = s.getItem();
            for (RecipeHolder<SalvagingRecipe> recipe : SalvagingMenu.findMatch((Level)Minecraft.getInstance().level, stack)) {
                if (recipe == null) continue;
                for (SalvagingRecipe.OutputData d : ((SalvagingRecipe)recipe.value()).getOutputs()) {
                    int[] counts = SalvagingMenu.getSalvageCounts(d, stack);
                    matches.add(new SalvagingRecipe.OutputData(d.stack(), counts[0], counts[1]));
                }
            }
        }
        ArrayList<SalvagingRecipe.OutputData> compressed = new ArrayList<SalvagingRecipe.OutputData>();
        for (SalvagingRecipe.OutputData data : matches) {
            if (data == null) continue;
            boolean success = false;
            for (int i = 0; i < compressed.size(); ++i) {
                SalvagingRecipe.OutputData existing = compressed.get(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)data.stack(), (ItemStack)existing.stack())) continue;
                compressed.set(i, new SalvagingRecipe.OutputData(existing.stack(), existing.min() + data.min(), existing.max() + data.max()));
                success = true;
                break;
            }
            if (success) continue;
            compressed.add(data);
        }
        this.results = compressed;
        this.salvageBtn.active = !this.results.isEmpty();
    }

    public void render(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(gfx, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        int maxDisplay = Math.min(6, this.results.size());
        IntOpenHashSet skipSlots = new IntOpenHashSet();
        for (int i = 0; i < maxDisplay; ++i) {
            ItemStack display = this.results.get(i).stack();
            int displaySlot = -1;
            for (int slot = 12; slot < 18; ++slot) {
                if (skipSlots.contains(slot)) continue;
                ItemStack outStack = ((Slot)((SalvagingMenu)this.menu).slots.get(slot)).getItem();
                if (outStack.isEmpty()) {
                    displaySlot = slot;
                    skipSlots.add(slot);
                    break;
                }
                if (outStack.is(display.getItem())) break;
            }
            if (displaySlot == -1) continue;
            Slot slot = ((SalvagingMenu)this.menu).getSlot(displaySlot);
            SalvagingScreen.renderGuiItem(gfx, display, this.getGuiLeft() + slot.x, this.getGuiTop() + slot.y, GrayBufferSource::new);
        }
        this.renderTooltip(gfx, pMouseX, pMouseY);
    }

    public static void renderGuiItem(GuiGraphics gfx, ItemStack pStack, int pX, int pY, Function<MultiBufferSource, MultiBufferSource> wrapper) {
        boolean flag;
        Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = gfx.pose();
        posestack.pushPose();
        posestack.translate((float)pX, (float)pY, 100.0f);
        posestack.translate(8.0, 8.0, 0.0);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getItemRenderer().getModel(pStack, (Level)mc.level, (LivingEntity)mc.player, pX ^ pY);
        boolean bl = flag = !model.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Minecraft.getInstance().getItemRenderer().render(pStack, ItemDisplayContext.GUI, false, posestack, wrapper.apply((MultiBufferSource)buffer), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTick, int pX, int pY) {
        gfx.blit(TEXTURE, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics gfx, int x, int y) {
        PoseStack stack = gfx.pose();
        stack.pushPose();
        stack.translate(0.0f, 0.0f, -100.0f);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.translatable((String)"text.apotheosis.salvage_results").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        for (SalvagingRecipe.OutputData data : this.results) {
            tooltip.add(Component.translatable((String)"%s-%s %s", (Object[])new Object[]{data.min(), data.max(), data.stack().getHoverName()}));
        }
        if (tooltip.size() > 1) {
            this.drawOnLeft(gfx, tooltip, this.getGuiTop() + 29);
        }
        stack.popPose();
        super.renderTooltip(gfx, x, y);
    }
}

