/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.effect.FestiveAffix;
import dev.shadowsoffire.apotheosis.affix.effect.MagicalArrowAffix;
import dev.shadowsoffire.apotheosis.affix.effect.OmneticAffix;
import dev.shadowsoffire.apotheosis.affix.effect.RadialAffix;
import dev.shadowsoffire.apotheosis.affix.effect.TelepathicAffix;
import dev.shadowsoffire.apotheosis.commands.AffixCommand;
import dev.shadowsoffire.apotheosis.commands.BossCommand;
import dev.shadowsoffire.apotheosis.commands.CategoryCheckCommand;
import dev.shadowsoffire.apotheosis.commands.DebugWeightCommand;
import dev.shadowsoffire.apotheosis.commands.GemCommand;
import dev.shadowsoffire.apotheosis.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.commands.ReforgeCommand;
import dev.shadowsoffire.apotheosis.commands.SocketCommand;
import dev.shadowsoffire.apotheosis.commands.WorldTierCommand;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.net.RadialStatePayload;
import dev.shadowsoffire.apotheosis.net.WorldTierPayload;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.OmneticBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.RadialBonus;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import dev.shadowsoffire.apotheosis.util.RadialUtil;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.event.ApotheosisCommandEvent;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.events.AnvilLandEvent;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class AdventureEvents {
    private static ThreadLocal<AtomicBoolean> reentrantLock = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    @SubscribeEvent
    public void cmds(ApotheosisCommandEvent e) {
        RarityCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        CategoryCheckCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        ReforgeCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        GemCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        SocketCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        BossCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        AffixCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        WorldTierCommand.register((LiteralArgumentBuilder<CommandSourceStack>)e.getRoot());
        LiteralArgumentBuilder debug = (LiteralArgumentBuilder)Commands.literal((String)"debug").requires(c -> c.hasPermission(4));
        DebugWeightCommand.register((LiteralArgumentBuilder<CommandSourceStack>)debug, e.getContext());
        e.getRoot().then((ArgumentBuilder)debug);
    }

    @SubscribeEvent
    public void affixModifiers(StackAttributeModifiersEvent e) {
        ItemStack stack = e.getItemStack();
        SocketHelper.getGems(stack).addModifiers(e);
        AffixHelper.streamAffixes(stack).forEach(inst -> inst.addModifiers(e));
    }

    @SubscribeEvent
    public void preventBossSuffocate(EntityInvulnerabilityCheckEvent e) {
        if (e.getSource().is(DamageTypes.IN_WALL) && e.getEntity().getPersistentData().contains("apoth.boss")) {
            e.setInvulnerable(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void fireProjectile(EntityJoinLevelEvent e) {
        Entity entity;
        Projectile proj;
        Entity entity2 = e.getEntity();
        if (entity2 instanceof Projectile && !(proj = (Projectile)entity2).getPersistentData().getBoolean("apoth.generated") && (entity = proj.getOwner()) instanceof LivingEntity) {
            LivingEntity user = (LivingEntity)entity;
            ItemStack weapon = user.getUseItem();
            if (weapon.isEmpty() && ((weapon = user.getMainHandItem()).isEmpty() || !LootCategory.forItem(weapon).isRanged())) {
                weapon = user.getOffhandItem();
            }
            if (weapon.isEmpty()) {
                return;
            }
            SocketHelper.getGems(weapon).onProjectileFired(user, proj);
            AffixHelper.streamAffixes(weapon).forEach(a -> a.onProjectileFired(user, proj));
            AffixHelper.copyToProjectile(weapon, (Entity)proj);
        }
    }

    @SubscribeEvent
    public void impact(ProjectileImpactEvent e) {
        Projectile projectile = e.getProjectile();
        if (projectile instanceof Projectile) {
            Projectile proj = projectile;
            SocketHelper.getGemInstances(proj).forEach(inst -> inst.onProjectileImpact(proj, e.getRayTraceResult()));
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(proj);
            affixes.values().forEach(inst -> inst.onProjectileImpact(proj, e.getRayTraceResult(), e.getRayTraceResult().getType()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void modifyIncomingDamageTags(EntityInvulnerabilityCheckEvent e) {
        MagicalArrowAffix.modifyIncomingDamageTags(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDamage(LivingIncomingDamageEvent e) {
        DamageSource src = e.getSource();
        LivingEntity ent = e.getEntity();
        float amount = e.getAmount();
        for (ItemStack s : ent.getAllSlots()) {
            amount = SocketHelper.getGems(s).onHurt(src, ent, amount);
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                amount = inst.onHurt(src, ent, amount);
            }
        }
        e.setAmount(amount);
    }

    @SubscribeEvent
    public void shieldBlock(LivingShieldBlockEvent e) {
        ItemStack stack = e.getEntity().getUseItem();
        Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        float blocked = e.getBlockedDamage();
        blocked = SocketHelper.getGems(stack).onShieldBlock(e.getEntity(), e.getDamageSource(), blocked);
        for (AffixInstance inst : affixes.values()) {
            blocked = inst.onShieldBlock(e.getEntity(), e.getDamageSource(), blocked);
        }
        if (blocked != e.getOriginalBlockedDamage()) {
            e.setBlockedDamage(blocked);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent e) {
        ItemStack stack = e.getPlayer().getMainHandItem();
        SocketHelper.getGems(stack).onBlockBreak(e.getPlayer(), e.getLevel(), e.getPos(), e.getState());
        AffixHelper.streamAffixes(stack).forEach(inst -> inst.onBlockBreak(e.getPlayer(), e.getLevel(), e.getPos(), e.getState()));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) {
        Entity entity = e.getSource().getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            AffixHelper.streamAffixes(p.getMainHandItem()).forEach(a -> a.modifyEntityLoot(e));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void deathMark(LivingDeathEvent e) {
        FestiveAffix.markEquipment(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        TelepathicAffix.drops(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(BlockDropsEvent e) {
        TelepathicAffix.drops(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void festive_removeMarker(LivingDropsEvent e) {
        FestiveAffix.removeMarker(e);
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck e) {
        OmneticAffix.harvest(e);
        OmneticBonus.harvest(e);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void speed(PlayerEvent.BreakSpeed e) {
        OmneticAffix.speed(e);
        OmneticBonus.speed(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(BlockEvent.BreakEvent e) {
        RadialAffix.onBreak(e);
        RadialBonus.onBreak(e);
    }

    @SubscribeEvent
    public void gemSmashing(AnvilLandEvent e) {
        Level level = e.getLevel();
        BlockPos pos = e.getPos();
        List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(pos));
        for (ItemEntity ent : items) {
            ItemStack stack = ent.getItem();
            if (!stack.is(Apoth.Items.GEM)) continue;
            ent.setItem(new ItemStack(Apoth.Items.GEM_DUST, stack.getCount()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void enchLevels(GetEnchantmentLevelEvent e) {
        boolean isReentrant = reentrantLock.get().getAndSet(true);
        if (isReentrant) {
            return;
        }
        SocketHelper.getGems(e.getStack()).getEnchantmentLevels(e);
        AffixHelper.streamAffixes(e.getStack()).forEach(inst -> inst.getEnchantmentLevels(e));
        reentrantLock.get().set(false);
    }

    @SubscribeEvent
    public void update(EntityTickEvent.Post e) {
        Entity entity = e.getEntity();
        if (entity.getPersistentData().contains("apoth.burns_in_sun") && entity.level().isDay() && !entity.level().isClientSide) {
            boolean flag;
            float f = entity.getLightLevelDependentMagicValue();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
            boolean bl = flag = entity.isInWaterRainOrBubble() || entity.isInPowderSnow || entity.wasInPowderSnow;
            if (f > 0.5f && entity.getRandom().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && entity.level().canSeeSky(blockpos)) {
                entity.setRemainingFireTicks(160);
            }
        }
    }

    @SubscribeEvent
    public void despawn(MobDespawnEvent e) {
        Mob mob = e.getEntity();
        if (mob instanceof AbstractGolem) {
            int despawnDist;
            int dsDistSq;
            double dist;
            Player player;
            AbstractGolem g = (AbstractGolem)mob;
            if (g.tickCount > 12000 && g.getPersistentData().getBoolean("apoth.boss") && (player = g.level().getNearestPlayer((Entity)g, -1.0)) != null && (dist = player.distanceToSqr((Entity)g)) > (double)(dsDistSq = (despawnDist = g.getType().getCategory().getDespawnDistance()) * despawnDist)) {
                e.setResult(MobDespawnEvent.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void clone(PlayerEvent.Clone e) {
        int oldSeed = e.getOriginal().getPersistentData().getInt("apoth_reforge_seed");
        e.getEntity().getPersistentData().putInt("apoth_reforge_seed", oldSeed);
    }

    @SubscribeEvent
    public void equip(LivingEquipmentChangeEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Apoth.Triggers.EQUIPPED_ITEM.trigger(player, e.getSlot(), e.getTo());
        }
    }

    @SubscribeEvent
    public void sendWorldTierDataOnJoin(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new WorldTierPayload(WorldTier.getTier((Player)p)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void applyMissedTierAugments(EntityJoinLevelEvent e) {
        if (e.getLevel().isClientSide) {
            return;
        }
        Entity entity = e.getEntity();
        if (((Boolean)entity.getData(Apoth.Attachments.TIER_AUGMENTS_APPLIED)).booleanValue()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            WorldTier tier = (WorldTier)((Object)player.getData(Apoth.Attachments.WORLD_TIER));
            for (TierAugment aug : TierAugmentRegistry.getAugments(tier, TierAugment.Target.PLAYERS)) {
                aug.apply((ServerLevelAccessor)e.getLevel(), (LivingEntity)player);
            }
            entity.setData(Apoth.Attachments.TIER_AUGMENTS_APPLIED, (Object)true);
        } else if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            float healthPct = mob.getHealth() / mob.getMaxHealth();
            Player player = e.getLevel().getNearestPlayer((Entity)mob, -1.0);
            if (player != null) {
                WorldTier tier = (WorldTier)((Object)player.getData(Apoth.Attachments.WORLD_TIER));
                for (TierAugment aug : TierAugmentRegistry.getAugments(tier, TierAugment.Target.MONSTERS)) {
                    aug.apply((ServerLevelAccessor)e.getLevel(), (LivingEntity)mob);
                }
                entity.setData(Apoth.Attachments.TIER_AUGMENTS_APPLIED, (Object)true);
            }
            mob.setHealth(healthPct * mob.getMaxHealth());
        }
    }

    @SubscribeEvent
    public void sync(OnDatapackSyncEvent e) {
        AdventureConfig.ConfigPayload payload = new AdventureConfig.ConfigPayload();
        e.getRelevantPlayers().forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @SubscribeEvent
    public void recordColdDamage(LivingDamageEvent.Post e) {
        if (e.getSource().is(ALObjects.DamageTypes.COLD_DAMAGE)) {
            LivingEntity entity = e.getEntity();
            entity.setData(Apoth.Attachments.COLD_DAMAGE_TAKEN, (Object)Float.valueOf(((Float)entity.getData(Apoth.Attachments.COLD_DAMAGE_TAKEN)).floatValue() + e.getNewDamage()));
        }
    }

    @SubscribeEvent
    public void stackedOnOther(ItemStackedOnOtherEvent e) {
        ItemStack gemStack;
        ItemStack stack;
        ItemStack socketed;
        Slot slot = e.getSlot();
        SlotAccess access = e.getCarriedSlotAccess();
        if (e.getClickAction() == ClickAction.SECONDARY && e.getCarriedItem().is(Apoth.Items.GEM) && slot.allowModification(e.getPlayer()) && !(socketed = SocketHelper.socketGemInItem(stack = e.getStackedOnItem(), gemStack = e.getCarriedItem())).isEmpty()) {
            slot.set(socketed);
            access.set(gemStack.copyWithCount(gemStack.getCount() - 1));
            e.setCanceled(true);
            e.getPlayer().playSound(SoundEvents.AMETHYST_BLOCK_BREAK, 1.0f, 1.5f + 0.35f * (1.0f - 2.0f * e.getPlayer().getRandom().nextFloat()));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void removeCloudsOnDeath(LivingDeathEvent e) {
        if (e.getEntity().getPersistentData().getBoolean("apoth.miniboss")) {
            for (Entity passenger : e.getEntity().getPassengers()) {
                if (!(passenger instanceof AreaEffectCloud)) continue;
                AreaEffectCloud cloud = (AreaEffectCloud)passenger;
                cloud.discard();
            }
        }
    }

    @SubscribeEvent
    public void syncRadialState(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RadialStatePayload(RadialUtil.RadialState.getState((Player)player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

