/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.client.model;

import com.github.bigenergy.glassential.client.model.OneWayBakedModel;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;

public class OneWayModelGeometry
implements IUnbakedGeometry<OneWayModelGeometry> {
    private final ResourceLocation glassModel;

    public OneWayModelGeometry(ResourceLocation glassModel) {
        this.glassModel = glassModel;
    }

    @NotNull
    public BakedModel bake(@NotNull IGeometryBakingContext iGeometryBakingContext, ModelBaker modelBaker, @NotNull Function<Material, TextureAtlasSprite> function, @NotNull ModelState modelState, @NotNull ItemOverrides itemOverrides) {
        BakedModel glass = modelBaker.bake(this.glassModel, modelState);
        return new OneWayBakedModel(glass);
    }

    public static class Loader
    implements IGeometryLoader<OneWayModelGeometry> {
        @NotNull
        public OneWayModelGeometry read(@NotNull JsonObject json, @NotNull JsonDeserializationContext ctx) throws JsonParseException {
            String glassStr = GsonHelper.getAsString((JsonObject)json, (String)"glass_model", (String)"minecraft:block/glass");
            ResourceLocation glass = ResourceLocation.tryParse((String)glassStr);
            if (glass == null) {
                throw new JsonParseException("Invalid glass_model: " + glassStr);
            }
            return new OneWayModelGeometry(glass);
        }
    }
}

