/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.kinetics;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessing;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WhirlProcessing
extends FanProcessing {
    public static boolean applyProcessing(ItemEntity entity, FanProcessingType type, Level world, SpellResolver whirlOwner) {
        double processingBoost = 0.0;
        if (SpellResolverHelpers.hasTransmutationFocus(whirlOwner)) {
            processingBoost += 1.0;
        }
        if (WhirlProcessing.decrementProcessingTime(entity, type, processingBoost) != 0) {
            return false;
        }
        List<ItemStack> stacks = type.process(entity.getItem(), entity.level());
        if (stacks == null || stacks.isEmpty()) {
            entity.discard();
            return false;
        }
        stacks = WhirlProcessing.applyCustomProcessing(stacks, entity, type, world, whirlOwner);
        entity.setItem(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), additional);
            entityIn.setDeltaMovement(entity.getDeltaMovement());
            entity.level().addFreshEntity((Entity)entityIn);
        }
        return true;
    }

    private static List<ItemStack> applyCustomProcessing(List<ItemStack> stacks, ItemEntity entity, FanProcessingType type, Level world, SpellResolver whirlOwner) {
        Optional<ProcessingRecipe> recipe;
        if (SpellResolverHelpers.shouldDoubleOutputs(whirlOwner) && !(recipe = WhirlProcessing.getProcessingRecipeForEntity(entity, type, world)).isEmpty()) {
            for (ItemStack stack : stacks) {
                if (!RecipeHelpers.isChanceBased(stack, recipe.get())) continue;
                stack.grow(stack.getCount());
            }
        }
        return stacks;
    }

    private static Optional<ProcessingRecipe> getProcessingRecipeForEntity(ItemEntity entity, FanProcessingType type, Level world) {
        if (type == AllFanProcessingTypes.SPLASHING) {
            return RecipeHelpers.getSplashingRecipeForItemStack(entity.getItem(), world);
        }
        if (type == AllFanProcessingTypes.HAUNTING) {
            return RecipeHelpers.getHauntingRecipeForItemStack(entity.getItem(), world);
        }
        return Optional.empty();
    }

    private static ResourceLocation getIdOrThrow(FanProcessingType type) {
        ResourceLocation id = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.getKey((Object)type);
        if (id == null) {
            throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(type));
        }
        return id;
    }

    private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type, double processingBoost) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.contains("CreateData")) {
            nbt.put("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.getCompound("CreateData")).contains("Processing")) {
            createData.put("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.getCompound("Processing")).contains("Type") || AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
            processing.putString("Type", WhirlProcessing.getIdOrThrow(type).toString());
            int timeModifierForStackSize = (entity.getItem().getCount() - 1) / 16 + 1;
            int baseProcessingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            int processingTime = (int)((double)baseProcessingTime / (1.0 + processingBoost));
            processing.putInt("Time", processingTime);
        }
        int value = processing.getInt("Time") - 1;
        processing.putInt("Time", value);
        return value;
    }
}

