/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionType;
import com.zeroregard.ars_technica.entity.fusion.fluids.FluidSourceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class MixingRecipeHelpers {
    public static Optional<MixingRecipeResult> getMixingRecipe(List<ItemEntity> items, List<FluidSourceProvider> fluids, Level world, ArcaneFusionType fusionType) {
        RecipeManager recipeManager = world.getRecipeManager();
        List<MixingRecipe> mixingRecipes = recipeManager.getAllRecipesFor(AllRecipeTypes.MIXING.getType()).stream().map(RecipeHolder::value).filter(recipe -> recipe instanceof MixingRecipe).map(MixingRecipe.class::cast).filter(x -> x.getRequiredHeat() == fusionType.getSuppliedHeat()).toList();
        for (MixingRecipe mixingRecipe : mixingRecipes) {
            ArrayList<FluidSourceProvider> usedFluids;
            ArrayList<ItemEntity> usedEntities;
            boolean matches = MixingRecipeHelpers.mixingRecipeIngredientsMatch(mixingRecipe, items, fluids, usedEntities = new ArrayList<ItemEntity>(), usedFluids = new ArrayList<FluidSourceProvider>());
            if (!matches) continue;
            MixingRecipeResult result = new MixingRecipeResult(mixingRecipe, usedEntities, usedFluids);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static boolean mixingRecipeIngredientsMatch(MixingRecipe recipe, List<ItemEntity> availableItems, List<FluidSourceProvider> availableFluids, List<ItemEntity> usedEntities, List<FluidSourceProvider> usedFluids) {
        HashMap<ItemEntity, Integer> usageMap = new HashMap<ItemEntity, Integer>();
        block0: for (Ingredient itemIngredient : recipe.getIngredients()) {
            for (ItemStack ingredientVariant : itemIngredient.getItems()) {
                Optional<ItemEntity> itemCandidate = availableItems.stream().filter(item -> item.getItem().getItem() == ingredientVariant.getItem()).findFirst();
                if (!itemCandidate.isPresent()) continue;
                ItemEntity candidateUnwrapped = itemCandidate.get();
                int usedCount = usageMap.getOrDefault(candidateUnwrapped, 0);
                int candidateItemCount = candidateUnwrapped.getItem().getCount();
                if (candidateItemCount < ingredientVariant.getCount() || candidateItemCount <= usedCount) continue;
                usedEntities.add(candidateUnwrapped);
                usageMap.put(candidateUnwrapped, usedCount + 1);
                continue block0;
            }
        }
        if (usedEntities.size() < recipe.getIngredients().size()) {
            return false;
        }
        block2: for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            for (FluidStack ingredientVariant : fluidIngredient.getMatchingFluidStacks()) {
                FluidSourceProvider candidateUnwrapped;
                Optional<FluidSourceProvider> fluidCandidate = availableFluids.stream().filter(fluid -> fluid.getFluidStack().getFluid() == ingredientVariant.getFluid()).findFirst();
                if (!fluidCandidate.isPresent() || (candidateUnwrapped = fluidCandidate.get()).getMbAmount() < ingredientVariant.getAmount()) continue;
                usedFluids.add(candidateUnwrapped);
                continue block2;
            }
        }
        return usedEntities.size() == recipe.getIngredients().size() && usedFluids.size() == recipe.getFluidIngredients().size();
    }

    public static class MixingRecipeResult {
        public MixingRecipe recipe;
        public List<ItemEntity> usedEntities;
        public List<FluidSourceProvider> usedFluids;

        public MixingRecipeResult(MixingRecipe recipe, List<ItemEntity> usedEntities, List<FluidSourceProvider> usedFluids) {
            this.recipe = recipe;
            this.usedEntities = usedEntities;
            this.usedFluids = usedFluids;
        }
    }
}

