/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemHelpers {
    public static void createItemEntity(ItemStack item, Level world, BlockPos pos) {
        ItemEntity entity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), item);
        world.addFreshEntity((Entity)entity);
    }

    public static void subtractItemsFromItemEntities(List<ItemEntity> itemEntities, int totalItemsToRemove, Item item, BlockPos pos, Level world) {
        ArrayList<ItemEntity> entitiesToUpdate = new ArrayList<ItemEntity>();
        for (ItemEntity entity : itemEntities) {
            ItemStack stack = entity.getItem();
            int countToRemove = Math.min(stack.getCount(), totalItemsToRemove);
            stack.shrink(countToRemove);
            totalItemsToRemove -= countToRemove;
            if (stack.getCount() > 0) {
                entitiesToUpdate.add(entity);
                continue;
            }
            entity.discard();
        }
        for (ItemEntity oldEntity : entitiesToUpdate) {
            int count = oldEntity.getItem().getCount();
            ItemStack newStack = new ItemStack((ItemLike)item, count);
            ItemEntity newEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), newStack);
            world.addFreshEntity((Entity)newEntity);
            oldEntity.discard();
        }
    }
}

