/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.ArcaneHammerEntity;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.util.Color;

public class EffectObliterate
extends AbstractEffect {
    public static EffectObliterate INSTANCE = new EffectObliterate(ArsTechnica.prefix("glyph_obliterate"), "Obliterate");

    private EffectObliterate(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.getEntity();
        Vec3 position = target.getPosition(1.0f);
        this.resolve(target, position, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 position = rayTraceResult.getBlockPos().getCenter().add(0.0, 0.5, 0.0);
        this.resolve(null, position, world, shooter, spellStats, spellContext, resolver);
    }

    private void resolve(@Nullable Entity target, Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Color color = new Color(spellContext.getColors().getColor());
        SpellContext newContext = spellContext.makeChildContext();
        spellContext.setCanceled(true);
        ArcaneHammerEntity arcaneHammerEntity = new ArcaneHammerEntity(target, position, world, (Entity)shooter, color, resolver.getNewResolver(newContext), spellStats);
        this.setYaw(position, shooter, arcaneHammerEntity);
        world.addFreshEntity((Entity)arcaneHammerEntity);
    }

    private void setYaw(Vec3 position, @NotNull LivingEntity shooter, ArcaneHammerEntity arcaneHammerEntity) {
        Vec3 direction = position.subtract(shooter.position()).normalize();
        float yaw = (float)(-Math.atan2(direction.z(), direction.x()) + 1.5707963267948966);
        arcaneHammerEntity.setYaw(yaw);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Processes items instead of destroying them");
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Increases the size and damage of the hammer");
        map.put((AbstractAugment)AugmentFortune.INSTANCE, "Increases the chance of getting additional items from crushing recipes by 25% per level");
    }

    public int getDefaultManaCost() {
        return 100;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE, AugmentAmplify.INSTANCE, AugmentFortune.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Obliterates foes by sheer force with an arcane hammer. Use Sensitive to crush items instead of destroying them";
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentFortune.INSTANCE.getRegistryName(), 4);
    }
}

