/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity.fusion;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.zeroregard.ars_technica.client.particles.SpiralDustParticleTypeData;
import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ArcaneFusionParticles {
    private final ArcaneFusionEntity parent;
    private final Level world;
    private ItemStack ingredientA;
    private ItemStack ingredientB;
    private ItemStack ingredientC;
    private ItemStack ingredientD;
    private List<ItemStack> recipeItemStacks;
    private boolean rendered_impact_particles = false;
    private static float TIME_TO_ANGLE_MULTIPLIER = 1.5f;

    public ArcaneFusionParticles(ArcaneFusionEntity parent, Level world) {
        this.parent = parent;
        this.world = world;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (ArcaneFusionEntity.INGREDIENT_A.equals(key)) {
            this.ingredientA = this.getItemStackFromRegistry((String)this.parent.getEntityData().get(ArcaneFusionEntity.INGREDIENT_A));
        }
        if (ArcaneFusionEntity.INGREDIENT_B.equals(key)) {
            this.ingredientB = this.getItemStackFromRegistry((String)this.parent.getEntityData().get(ArcaneFusionEntity.INGREDIENT_B));
        }
        if (ArcaneFusionEntity.INGREDIENT_C.equals(key)) {
            this.ingredientC = this.getItemStackFromRegistry((String)this.parent.getEntityData().get(ArcaneFusionEntity.INGREDIENT_C));
        }
        if (ArcaneFusionEntity.INGREDIENT_D.equals(key)) {
            this.ingredientD = this.getItemStackFromRegistry((String)this.parent.getEntityData().get(ArcaneFusionEntity.INGREDIENT_D));
        }
    }

    private void setIngredientList() {
        if (this.recipeItemStacks == null && this.ingredientA != null) {
            ArrayList<ItemStack> temporaryList = new ArrayList<ItemStack>(Arrays.asList(this.ingredientA));
            this.addNonNullToList(this.ingredientB, temporaryList);
            this.addNonNullToList(this.ingredientC, temporaryList);
            this.addNonNullToList(this.ingredientD, temporaryList);
            this.recipeItemStacks = temporaryList.stream().toList();
        }
    }

    public void setIngredientsForParticles(List<ItemEntity> ingredients) {
        if (ingredients.size() > 0) {
            this.parent.getEntityData().set(ArcaneFusionEntity.INGREDIENT_A, (Object)this.getItemRegistryName(ingredients.get(0).getItem().getItem()));
        }
        if (ingredients.size() > 1) {
            this.parent.getEntityData().set(ArcaneFusionEntity.INGREDIENT_B, (Object)this.getItemRegistryName(ingredients.get(1).getItem().getItem()));
        }
        if (ingredients.size() > 2) {
            this.parent.getEntityData().set(ArcaneFusionEntity.INGREDIENT_C, (Object)this.getItemRegistryName(ingredients.get(2).getItem().getItem()));
        }
        if (ingredients.size() > 3) {
            this.parent.getEntityData().set(ArcaneFusionEntity.INGREDIENT_D, (Object)this.getItemRegistryName(ingredients.get(3).getItem().getItem()));
        }
    }

    private String getItemRegistryName(Item item) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)item);
        return registryName != null ? registryName.toString() : "";
    }

    private void addNonNullToList(@Nullable ItemStack itemStack, ArrayList<ItemStack> list) {
        if (itemStack != null) {
            list.add(itemStack);
        }
    }

    private ItemStack getItemStackFromRegistry(String registryName) {
        if (registryName.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ResourceLocation resourceLocation = ResourceLocation.parse((String)registryName);
        Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
        return item != null ? new ItemStack((ItemLike)item) : ItemStack.EMPTY;
    }

    public void handleParticles() {
        this.setIngredientList();
        if (this.world == null || this.recipeItemStacks == null) {
            return;
        }
        if (!this.parent.getImpacted()) {
            float diameterMultiplier = this.parent.getSwung() ? 1.0f - (this.parent.getElapsedTime() - ArcaneFusionEntity.CHARGE_TIME) * 2.0f : 1.0f;
            this.renderCircleParticles(diameterMultiplier);
            this.renderFusionParticles();
        }
        if (this.parent.getImpacted() && !this.rendered_impact_particles) {
            this.renderImpactParticles();
            this.rendered_impact_particles = true;
        }
    }

    private void renderCircleParticles(float diameterMultiplier) {
        int numStacks = Math.min(this.recipeItemStacks.size(), 4);
        double angleStep = 360.0 / (double)numStacks;
        Vec3 center = this.parent.getPosition(1.0f);
        float elapsedTime = this.parent.getElapsedTime();
        double speedMultiplier = (double)TIME_TO_ANGLE_MULTIPLIER * Math.exp((double)elapsedTime / 1.0);
        double circleDiameter = (double)0.3f * Math.exp(elapsedTime) * (double)diameterMultiplier;
        double circleRadius = circleDiameter / 2.0;
        for (int i = 0; i < numStacks; ++i) {
            double angle = Math.toRadians((double)i * angleStep) + (double)elapsedTime * speedMultiplier;
            double offsetX = circleRadius * Math.cos(angle) + this.parent.getRandom().nextGaussian() * 0.1;
            double offsetZ = circleRadius * Math.sin(angle) + this.parent.getRandom().nextGaussian() * 0.1;
            Vec3 particlePos = center.add(offsetX, 0.25, offsetZ);
            ItemStack itemStack = this.recipeItemStacks.get(i);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, itemStack);
            this.world.addParticle((ParticleOptions)data, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.1, 0.0);
        }
    }

    private void renderFusionParticles() {
        if (this.parent.getTickCount() % 2 == 0) {
            int particleColorIndex = this.parent.getRandom().nextIntBetweenInclusive(0, 2);
            ParticleColor particleColor = this.parent.getFusionType().getParticleColors().get(particleColorIndex);
            SpiralDustParticleTypeData particleData = new SpiralDustParticleTypeData(particleColor, false, 1.0f, 1.0f, 20);
            this.addParticle(particleData, Math.toRadians(this.parent.getRandom().nextGaussian() * 360.0), 0.0, 0.04, 0.0);
        }
    }

    private void renderImpactParticles() {
        this.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            this.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, 0.0, 2.0E-4, 0.4, 0.05);
        }
        int itemParticleCount = 16;
        double angleStep = 360.0 / (double)itemParticleCount;
        for (int i = 0; i < 16; ++i) {
            double angle = Math.toRadians((double)i * angleStep);
            ItemStack itemStack = this.recipeItemStacks.get(i % this.recipeItemStacks.size());
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, itemStack);
            this.addParticle((ParticleOptions)data, angle, 0.1, 0.2, 0.2);
        }
    }

    private void addParticle(ParticleOptions particleData, double angle, double speedMultiplier, double offsetMultiplier, double ySpeed) {
        double offsetX = this.parent.getRandom().nextGaussian() * offsetMultiplier;
        double offsetY = this.parent.getRandom().nextGaussian() * offsetMultiplier;
        double offsetZ = this.parent.getRandom().nextGaussian() * offsetMultiplier;
        double speedX = Math.cos(angle) + this.parent.getRandom().nextGaussian() * speedMultiplier;
        double speedZ = Math.sin(angle) + this.parent.getRandom().nextGaussian() * speedMultiplier;
        this.world.addParticle(particleData, this.parent.getX() + offsetX, this.parent.getY() + offsetY, this.parent.getZ() + offsetZ, speedX, ySpeed, speedZ);
    }
}

