/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.zeroregard.ars_technica.entity.Colorable;
import java.util.Comparator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.util.Color;

public abstract class ArcaneProcessEntity
extends Entity
implements Colorable {
    private static int TICKS_TO_PROCESS_RATIO = 20;
    private static int TICKS_TO_RESET_RATIO = TICKS_TO_PROCESS_RATIO * 2;
    protected double distanceToItem = 1.0;
    protected int maxToProcess = 1;
    protected float speed = 2.0f;
    protected int amountProcessed = 0;
    protected final List<ItemEntity> processableEntities;
    protected ItemEntity currentItem;
    protected ItemEntity currentOutput;
    protected int tickCount;
    protected Color color;
    protected Level world;
    protected static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    private int getTicksToPress() {
        return Math.round((float)TICKS_TO_PROCESS_RATIO / this.speed);
    }

    private int getTicksToReset() {
        return Math.round((float)TICKS_TO_RESET_RATIO / this.speed);
    }

    protected void setSpeed(float speed) {
        this.entityData.set(SPEED, (Object)Float.valueOf(speed));
    }

    protected void setColor(Color color) {
        this.entityData.set(COLOR, (Object)color.getColor());
    }

    public ArcaneProcessEntity(EntityType<?> entityType, Vec3 position, Level world, int maxToProcess, float speed, Color color, List<ItemEntity> processableEntities) {
        super(entityType, world);
        this.setPos(position.x, position.y, position.z);
        this.maxToProcess = maxToProcess;
        this.speed = speed;
        this.setSpeed(speed);
        this.setColor(color);
        this.processableEntities = processableEntities;
        this.world = world;
    }

    public ArcaneProcessEntity(EntityType<? extends ArcaneProcessEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
        this.processableEntities = null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder dataBuilder) {
        dataBuilder.define(SPEED, (Object)Float.valueOf(2.0f));
        dataBuilder.define(COLOR, (Object)0);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.entityData.get(SPEED)).floatValue();
        }
        if (COLOR.equals(key)) {
            this.color = new Color(((Integer)this.entityData.get(COLOR)).intValue());
        }
    }

    public void tick() {
        super.tick();
        if (this.currentItem == null || this.currentItem.isRemoved()) {
            this.findNextItem();
        }
        if (!(this.amountProcessed != this.maxToProcess && this.currentItem != null || this.world.isClientSide)) {
            this.discard();
        }
        this.handleProcessLogic();
        if (this.tickCount >= this.getTicksToReset()) {
            if (this.currentItem != null && !this.currentItem.isRemoved()) {
                this.moveToItem();
            }
            this.tickCount = 0;
        }
        ++this.tickCount;
    }

    protected void growOutput(ItemEntity input, ItemStack outputStack) {
        if (this.currentOutput != null && this.currentOutput.getItem().getItem() == outputStack.getItem() && this.currentOutput.getItem().getCount() < this.currentOutput.getItem().getMaxStackSize()) {
            ItemStack currentOutputItem = this.currentOutput.getItem();
            ItemStack newStack = currentOutputItem.copyWithCount(currentOutputItem.getCount() + 1);
            this.currentOutput.discard();
            this.currentOutput = new ItemEntity(this.world, input.getX(), input.getY(), input.getZ(), newStack);
            this.world.addFreshEntity((Entity)this.currentOutput);
        } else {
            this.currentOutput = new ItemEntity(this.world, input.getX(), input.getY(), input.getZ(), outputStack);
            this.world.addFreshEntity((Entity)this.currentOutput);
        }
    }

    protected void moveToItem() {
        this.setPos(this.currentItem.position().add(0.0, this.distanceToItem, 0.0));
    }

    private void findNextItem() {
        if (this.processableEntities == null) {
            return;
        }
        this.currentItem = this.processableEntities.stream().filter(x -> x != null && !x.isRemoved() && x.getItem().getCount() > 0).min(Comparator.comparingDouble(e -> e.position().distanceTo(this.getPosition(1.0f)))).orElse(null);
    }

    private void handleProcessLogic() {
        if (this.currentItem != null && this.tickCount == this.getTicksToPress() && !this.world.isClientSide()) {
            if (this.currentItem.isRemoved()) {
                this.currentItem = null;
            } else {
                this.process(this.currentItem);
            }
        }
    }

    protected abstract void process(ItemEntity var1);

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Speed")) {
            this.speed = compound.getFloat("Speed");
            this.entityData.set(SPEED, (Object)Float.valueOf(this.speed));
        }
        if (compound.contains("Color")) {
            this.color = new Color(compound.getInt("Color"));
            this.entityData.set(COLOR, (Object)this.color.getColor());
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Speed", this.speed);
        compound.putInt("Color", this.color.getColor());
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public double getAlpha() {
        return 1.0;
    }
}

