/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client;

import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.zeroregard.ars_technica.block.PreciseRelayRenderer;
import com.zeroregard.ars_technica.block.SourceMotorRenderer;
import com.zeroregard.ars_technica.client.entity.ArcaneFusionEntityRenderer;
import com.zeroregard.ars_technica.client.entity.ArcaneHammerEntityRenderer;
import com.zeroregard.ars_technica.client.entity.ArcanePolishEntityRenderer;
import com.zeroregard.ars_technica.client.entity.ArcanePressEntityRenderer;
import com.zeroregard.ars_technica.client.entity.ArcaneWhirlEntityRenderer;
import com.zeroregard.ars_technica.client.entity.ItemProjectileRenderer;
import com.zeroregard.ars_technica.client.item.SpyMonocleCurioRenderer;
import com.zeroregard.ars_technica.client.sound.EntityLoopingSound;
import com.zeroregard.ars_technica.entity.ArcaneWhirlEntity;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import com.zeroregard.ars_technica.registry.ItemRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@EventBusSubscriber(modid="ars_technica", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    private static float DEFAULT_PITCH = 0.8f;
    private static float SPEED_PITCH_MULTIPLIER = 4.0f;

    @SubscribeEvent
    public static void bindRenderers(EntityRenderersEvent.RegisterRenderers event) {
    }

    @SubscribeEvent
    public static void initItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemRegistry.TECHNOMANCER_BOOTS.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemRegistry.TECHNOMANCER_CHESTPLATE.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemRegistry.TECHNOMANCER_HELMET.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemRegistry.TECHNOMANCER_LEGGINGS.get()});
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpyMonocleCurioRenderer.SPY_MONOCLE_LAYER, () -> SpyMonocleCurioRenderer.createBodyLayer());
    }

    public static int colorFromArmor(ItemStack stack) {
        DyeColor color = (DyeColor)stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE);
        return FastColor.ABGR32.opaque((int)color.getTextColor());
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_POLISH_ENTITY.get(), ArcanePolishEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_HAMMER_ENTITY.get(), ArcaneHammerEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_PRESS_ENTITY.get(), ArcanePressEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_FUSION_ENTITY.get(), ArcaneFusionEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_WHIRL_ENTITY.get(), ArcaneWhirlEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ITEM_PROJECTILE_ENTITY.get(), ItemProjectileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EntityRegistry.SOURCE_MOTOR_BLOCK_ENTITY.get(), SourceMotorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EntityRegistry.PRECISE_RELAY_TILE.get(), PreciseRelayRenderer::new);
    }

    public static void handleWhirlSound(ArcaneWhirlEntity entity, FanProcessingType processor, float speed) {
        SoundEvent event = ClientHandler.getLoopingSoundFromType(processor);
        EntityLoopingSound sound = new EntityLoopingSound(entity, event, 0.5f, DEFAULT_PITCH + SPEED_PITCH_MULTIPLIER * speed);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }

    private static SoundEvent getLoopingSoundFromType(FanProcessingType processor) {
        if (processor == AllFanProcessingTypes.HAUNTING) {
            return (SoundEvent)SoundRegistry.WHIRL_HAUNT.get();
        }
        if (processor == AllFanProcessingTypes.SPLASHING) {
            return (SoundEvent)SoundRegistry.WHIRL_SPLASH.get();
        }
        if (processor == AllFanProcessingTypes.SMOKING || processor == AllFanProcessingTypes.BLASTING) {
            return (SoundEvent)SoundRegistry.WHIRL_SMELT.get();
        }
        return (SoundEvent)SoundRegistry.WHIRL_NONE.get();
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
    }

    @SubscribeEvent
    public static void bindContainerRenderers(RegisterMenuScreensEvent event) {
    }
}

