/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.block;

import com.hollingsworth.arsnouveau.common.block.Relay;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.zeroregard.ars_technica.block.PreciseRelayTile;
import com.zeroregard.ars_technica.client.gui.RelayTileScreen;
import com.zeroregard.ars_technica.helpers.mixin.IArsTechnicaWrenchAdjustable;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PreciseRelay
extends Relay
implements IArsTechnicaWrenchAdjustable {
    public PreciseRelay(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void handleWrenching(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RelayTile) {
            RelayTile relayTile = (RelayTile)blockEntity;
            if (world.isClientSide()) {
                this.displayScreen(relayTile, player);
            }
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_STEP, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(RelayTile be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new RelayTileScreen("gui.ars_technica.relay", be));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        PreciseRelayTile tile = new PreciseRelayTile(pos, state);
        return tile;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)BlockRegistry.RELAY.asItem()));
    }
}

