/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block.entity;

import java.util.Optional;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.TickAccumulator;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.AbstractBotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotBlockEntity
extends AbstractBotanyPotBlockEntity {
    public static final CachedSupplier<BlockEntityType<BotanyPotBlockEntity>> TYPE = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)BotanyPotsMod.id("botany_pot")).cast();
    private final BlockEntityContext recipeContext = new BlockEntityContext(this, null, null);
    private final ReloadableCache<RecipeHolder<Soil>> soil = ReloadableCache.of(level -> {
        Optional<SoilOverride> override = SoilOverride.get(this.getSoilItem());
        if (override.isPresent()) {
            return new RecipeHolder(BotanyPotsMod.BUILTIN_COMPONENT_ID, (Recipe)override.get().soil());
        }
        RecipeCache cache = (RecipeCache)Soil.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSoilItem(), this.recipeContext, (Level)level) : null;
    });
    private final ReloadableCache<RecipeHolder<Crop>> crop = ReloadableCache.of(level -> {
        Optional<CropOverride> override = CropOverride.get(this.getSeedItem());
        if (override.isPresent()) {
            return new RecipeHolder(BotanyPotsMod.BUILTIN_COMPONENT_ID, (Recipe)override.get().crop());
        }
        RecipeCache cache = (RecipeCache)Crop.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSeedItem(), this.recipeContext, (Level)level) : null;
    });
    public TickAccumulator growthTime = new TickAccumulator(-1.0f);
    public int comparatorLevel = 0;
    protected TickAccumulator exportCooldown = new TickAccumulator(0.0f);
    protected TickAccumulator growCooldown = new TickAccumulator(0.0f);
    private int bonemealCooldown = 0;

    public BotanyPotBlockEntity(BlockPos pos, BlockState state) {
        this((Supplier<BlockEntityType<BotanyPotBlockEntity>>)TYPE, pos, state);
    }

    public BotanyPotBlockEntity(Supplier<BlockEntityType<BotanyPotBlockEntity>> type, BlockPos pos, BlockState state) {
        super(type.get(), pos, state);
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, BotanyPotBlockEntity pot) {
        Crop crop;
        Soil soil;
        if (pot.isRemoved() || pot.level == null) {
            return;
        }
        if (pot.potType.get() == PotType.WAXED) {
            pot.growthTime.setTicks(Float.MAX_VALUE);
            return;
        }
        BlockEntityContext context = pot.recipeContext;
        if (pot.bonemealCooldown > 0) {
            --pot.bonemealCooldown;
        }
        if ((soil = pot.getOrInvalidateSoil()) != null) {
            soil.onTick(context, level);
        }
        if ((crop = pot.getOrInvalidateCrop()) != null) {
            crop.onTick(context, level);
            if (pot.growCooldown.getTicks() > 0.0f) {
                pot.growCooldown.tickDown(level);
            }
            if (pot.growCooldown.getTicks() <= 0.0f && crop.isGrowthSustained(context, level)) {
                pot.growthTime.tickUp(level);
                crop.onGrowthTick(context, level);
                int requiredGrowthTicks = Helpers.getRequiredGrowthTicks(pot.recipeContext, pot.level, crop, soil);
                if (pot.growthTime.getTicks() >= (float)requiredGrowthTicks) {
                    pot.updateComparatorLevel(15);
                    pot.growCooldown.setTicks(5.0f);
                    if (pot.isHopper() && crop.canHarvest(context, level)) {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            int rolls = Helpers.getLootRolls(context, level, crop, soil);
                            for (int roll = 0; roll < rolls; ++roll) {
                                crop.onHarvest(context, level, stack -> Services.GAMEPLAY.addItem(stack, pot.getItems(), STORAGE_SLOTS));
                            }
                            if (((Config)BotanyPotsMod.CONFIG.get()).gameplay.damage_harvest_tool && EnchantmentLevel.FIRST.get(Helpers.NEGATE_HARVEST_DAMAGE_TAG, pot.getHarvestItem()) <= 0) {
                                pot.getHarvestItem().hurtAndBreak(1, serverLevel, null, stack -> {});
                            }
                            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)pot.getBlockState()));
                        }
                        pot.growthTime.reset();
                    }
                } else {
                    pot.updateComparatorLevel(Mth.ceil((float)(14.0f * (pot.growthTime.getTicks() / (float)requiredGrowthTicks))));
                }
            }
        }
        if (pot.isHopper()) {
            pot.exportCooldown.tickDown(level);
            if (pot.exportCooldown.getTicks() <= 0.0f) {
                ServerLevel serverLevel;
                if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).getBlockState((BlockPos)pot.below.get()).isAir()) {
                    for (int slot : STORAGE_SLOTS) {
                        ItemStack stack2 = pot.getItem(slot);
                        if (stack2.isEmpty()) continue;
                        ItemStack result = Services.GAMEPLAY.inventoryInsert(serverLevel, (BlockPos)pot.below.get(), Direction.UP, stack2);
                        pot.setItem(slot, result);
                    }
                }
                pot.exportCooldown.reset();
            }
        }
    }

    public boolean canHarvest() {
        Soil soil = this.getOrInvalidateSoil();
        Crop crop = this.getOrInvalidateCrop();
        return soil != null && crop != null && this.growthTime.getTicks() >= (float)Helpers.getRequiredGrowthTicks(this.getRecipeContext(), this.level, crop, soil) && crop.canHarvest(this.getRecipeContext(), this.level);
    }

    public void reset() {
        this.growthTime.reset();
        this.updateComparatorLevel(0);
        this.crop.invalidate();
        this.soil.invalidate();
        this.bonemealCooldown = 0;
    }

    public void updateGrowthTime(float newTime) {
        this.growthTime.setTicks(newTime);
        this.markUpdated();
    }

    public void updateComparatorLevel(int newLevel) {
        Level level;
        if (newLevel != this.comparatorLevel && !this.isRemoved() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.comparatorLevel = newLevel;
            serverLevel.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    public float growthTime() {
        return this.growthTime.getTicks();
    }

    public BlockEntityContext getRecipeContext() {
        return this.recipeContext;
    }

    public boolean canBonemeal() {
        return this.bonemealCooldown <= 0;
    }

    public void setBonemealCooldown(int cooldown) {
        this.bonemealCooldown = cooldown;
    }

    @Override
    public void onSoilChanged(ItemStack newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onSeedChanged(ItemStack newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onToolChanged(ItemStack newStack) {
        this.markUpdated();
    }

    public Soil getOrInvalidateSoil() {
        return this.getOrInvalidate(this.getSoilItem(), this.soil);
    }

    public Crop getOrInvalidateCrop() {
        return this.getOrInvalidate(this.getSeedItem(), this.crop);
    }

    @Nullable
    public <T extends BotanyPotRecipe> T getOrInvalidate(ItemStack stack, ReloadableCache<RecipeHolder<T>> cache) {
        if (this.level == null || stack.isEmpty()) {
            cache.invalidate();
            return null;
        }
        RecipeHolder value = (RecipeHolder)cache.apply(this.level);
        if (value != null) {
            BotanyPotRecipe innerValue = (BotanyPotRecipe)value.value();
            if (!innerValue.matches(this.recipeContext, this.level)) {
                cache.invalidate();
                return null;
            }
            return (T)innerValue;
        }
        return null;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.growthTime.setTicks(tag.getFloat("growth_time"));
        this.comparatorLevel = tag.getInt("comparator_level");
        this.exportCooldown = new TickAccumulator(tag.getFloat("export_delay"));
        this.growCooldown = new TickAccumulator(tag.getFloat("grow_cooldown"));
        this.bonemealCooldown = tag.getInt("bonemeal_cooldown");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("growth_time", this.growthTime.getTicks());
        tag.putInt("comparator_level", this.comparatorLevel);
        tag.putFloat("export_delay", this.exportCooldown.getTicks());
        tag.putFloat("grow_cooldown", this.growCooldown.getTicks());
        tag.putInt("bonemeal_cooldown", this.bonemealCooldown);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag syncTag = this.saveCustomOnly(registries);
        syncTag.remove("comparator_level");
        syncTag.put("Items", (Tag)DataHelper.containerSubList((ListTag)syncTag.getList("Items", 10), slot -> slot <= 2));
        return syncTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInv) {
        return BotanyPotMenu.potMenuServer(containerId, playerInv, this);
    }

    public int getRequiredGrowthTicks() {
        RecipeHolder crop = (RecipeHolder)this.crop.apply(this.level);
        return crop == null ? -1 : Helpers.getRequiredGrowthTicks(this.recipeContext, this.level, (Crop)crop.value(), (Soil)this.soil.map(this.level, RecipeHolder::value));
    }
}

