/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.IContentProvider;
import net.darkhax.bookshelf.common.api.registry.register.ItemComponentRegister;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterBlockEntityRenderer;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotScreen;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.BotanyPotFileGenerator;
import net.darkhax.botanypots.common.impl.data.conditions.ConfigLoadCondition;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.darkhax.botanypots.common.impl.data.recipe.fertilizer.BasicFertilizer;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BlockDerivedSoil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;

public class BotanyPotsContent
implements IContentProvider {
    public static final Supplier<ItemStack> TAB_ICON = CachedSupplier.cache(() -> ((Item)BuiltInRegistries.ITEM.get(BotanyPotsMod.id("terracotta_botany_pot"))).getDefaultInstance());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<ResourceLocation, Block> allPotBlocks = new LinkedHashMap<ResourceLocation, Block>();

    private void generatePotFiles() {
        BotanyPotFileGenerator gen = new BotanyPotFileGenerator(new File("outdir"), "botanypots");
        this.make(gen, "terracotta");
        for (DyeColor dyeColor : DyeColor.values()) {
            this.make(gen, dyeColor.getName() + "_terracotta");
            this.make(gen, dyeColor.getName() + "_glazed_terracotta");
            this.make(gen, dyeColor.getName() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.make(gen, (String)(string.equalsIgnoreCase("brick") ? "bricks" : string + "_bricks"));
        }
    }

    private void make(BotanyPotFileGenerator gen, String block) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)block);
        gen.potRecipes(blockId);
        gen.models(blockId);
        gen.lootTables(blockId);
    }

    public void registerBlocks(Register<Block> registry) {
        this.createPots(registry, "terracotta");
        for (DyeColor dyeColor : DyeColor.values()) {
            this.createPots(registry, dyeColor.getName() + "_terracotta");
            this.createPots(registry, dyeColor.getName() + "_glazed_terracotta");
            this.createPots(registry, dyeColor.getName() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void createPots(Register<Block> registry, String name) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)name);
        MapColor color = BuiltInRegistries.BLOCK.containsKey(blockId) ? ((Block)BuiltInRegistries.BLOCK.get(blockId)).defaultMapColor() : MapColor.COLOR_ORANGE;
        this.registerPot(registry, name + "_botany_pot", (Block)new BotanyPotBlock(color, PotType.BASIC));
        this.registerPot(registry, name + "_hopper_botany_pot", (Block)new BotanyPotBlock(color, PotType.HOPPER));
        this.registerPot(registry, name + "_waxed_botany_pot", (Block)new BotanyPotBlock(color, PotType.WAXED));
    }

    private void registerPot(Register<Block> registry, String id, Block block) {
        ResourceLocation blockId = ResourceLocation.fromNamespaceAndPath((String)this.contentNamespace(), (String)id);
        registry.add(blockId, (Object)block);
        this.allPotBlocks.put(blockId, block);
    }

    public void registerItems(RegisterItem registry) {
        for (Map.Entry<ResourceLocation, Block> block : this.allPotBlocks.entrySet()) {
            registry.addBlock(block.getValue());
        }
    }

    public void registerBlockEntities(Register<BlockEntityType.Builder<?>> registry) {
        registry.add("botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder(BotanyPotBlockEntity::new, (Block[])this.allPotBlocks.values().toArray(Block[]::new)));
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDisplayTypes);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDropProviders);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerGrowthAmountTypes);
    }

    public void registerMenus(MenuRegister registry) {
        registry.add("basic_pot_menu", BotanyPotMenu::basicMenuClient);
        registry.add("hopper_pot_menu", BotanyPotMenu::hopperMenuClient);
    }

    public void registerRecipeTypes(RegisterRecipeType registry) {
        registry.add("soil");
        registry.add("crop");
        registry.add("pot_interaction");
        registry.add("fertilizer");
    }

    public void registerRecipeSerializers(Register<RecipeSerializer<?>> registry) {
        registry.add("soil", BasicSoil.SERIALIZER);
        registry.add("block_derived_soil", BlockDerivedSoil.SERIALIZER);
        registry.add("crop", BasicCrop.SERIALIZER);
        registry.add("block_derived_crop", BlockDerivedCrop.SERIALIZER);
        registry.add("pot_interaction", BasicPotInteraction.SERIALIZER);
        registry.add("fertilizer", BasicFertilizer.SERIALIZER);
    }

    public void registerLoadConditions(Register<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void registerItemTabs(RegisterItemTab registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (Block block : this.allPotBlocks.values()) {
                builder.accept((ItemLike)block.asItem());
            }
            float[] buffs = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 5.0f, 10.0f, 15.0f, 50.0f, 100.0f, 1000.0f};
            ResourceLocation yieldId = BotanyPotsMod.id("test_yield");
            ResourceLocation growthId = BotanyPotsMod.id("test_growth");
            for (float buff : buffs) {
                ItemStack yield = new ItemStack((ItemLike)Items.DIAMOND_HOE);
                BotanyPotsContent.addModifier(yield, Helpers.YIELD_MOD_ATTRIBUTE.get(), new AttributeModifier(yieldId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                yield.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(yield);
            }
            for (float buff : buffs) {
                ItemStack growth = new ItemStack((ItemLike)Items.GOLDEN_HOE);
                BotanyPotsContent.addModifier(growth, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new AttributeModifier(growthId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                growth.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(growth);
            }
            for (float buff : buffs) {
                ItemStack both = new ItemStack((ItemLike)Items.NETHERITE_HOE);
                BotanyPotsContent.addModifier(both, Helpers.YIELD_MOD_ATTRIBUTE.get(), new AttributeModifier(yieldId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                BotanyPotsContent.addModifier(both, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new AttributeModifier(growthId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                both.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(both);
            }
        });
    }

    private static ItemStack addModifier(ItemStack stack, Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup group) {
        ItemAttributeModifiers component = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        component = component.withModifierAdded(attribute, modifier, group);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)component);
        return stack;
    }

    public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        BotanyPotsCommands.build(dispatcher, context, selection);
    }

    public void bindBlockEntityRenderer(RegisterBlockEntityRenderer registry) {
        registry.bind((BlockEntityType)BotanyPotBlockEntity.TYPE.get(), BotanyPotRenderer::new);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::bindDisplayRenderers);
    }

    public void registerItemComponents(ItemComponentRegister registry) {
        registry.accept(CropOverride.TYPE_ID, b -> b.persistent(CropOverride.CODEC).networkSynchronized(CropOverride.STREAM));
        registry.accept(SoilOverride.TYPE_ID, b -> b.persistent(SoilOverride.CODEC).networkSynchronized(SoilOverride.STREAM));
    }

    public void registerMenuScreens(RegisterMenuScreen registry) {
        registry.bind((MenuType)BotanyPotMenu.BASIC_MENU.get(), BotanyPotScreen::new);
        registry.bind((MenuType)BotanyPotMenu.HOPPER_MENU.get(), BotanyPotScreen::new);
    }

    public void bindRenderLayers(BiConsumer<Block, RenderType> registry) {
        for (Block block : this.allPotBlocks.values()) {
            registry.accept(block, RenderType.cutout());
        }
    }

    public void registerAttributes(Register<Attribute> registry) {
        registry.add("growth", (Object)new RangedAttribute("attribute.botanypots.growth", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
        registry.add("yield", (Object)new RangedAttribute("attribute.botanypots.yield", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
    }

    public String contentNamespace() {
        return "botanypots";
    }

    public static Component modMessage(Component component) {
        return Component.translatable((String)"commands.botanypots.mod_message", (Object[])new Object[]{component});
    }
}

