/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.darkhax.botanypots.common.api.data.display.math.AxisAlignedRotation;
import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.RenderOptions;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public abstract class AbstractDisplayRenderer<T extends Display, O extends RenderOptions>
extends DisplayRenderer<T> {
    @Override
    public float render(BlockEntityRendererProvider.Context context, T display, PoseStack pose, Level level, BlockPos pos, float tickDelta, MultiBufferSource bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        O renderOptions = this.getRenderOptions(display);
        Vector3f scale = renderOptions.getScale();
        float scaleX = scale.x * growthScale;
        float scaleY = scale.y * growthScale;
        float scaleZ = scale.z * growthScale;
        Vector3f offset = renderOptions.getOffset();
        pose.pushPose();
        pose.translate(0.5f - scaleX / 2.0f, heightOffset, 0.5f - scaleZ / 2.0f);
        pose.translate(offset.x * scaleX, offset.y * scaleY, offset.z * scaleZ);
        pose.scale(scaleX, scaleY, scaleZ);
        for (AxisAlignedRotation rotation : renderOptions.getRotations()) {
            pose.mulPose(rotation.rotation);
            pose.translate(rotation.offset.x(), rotation.offset.y(), rotation.offset.z());
        }
        this.render(context, display, renderOptions, pose, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, growthScale, heightOffset);
        pose.popPose();
        heightOffset += offset.y * scaleY;
        return heightOffset += this.getHeight(display, renderOptions, level, pos, tickDelta, pot) * scaleY;
    }

    public abstract O getRenderOptions(T var1);

    public float getHeight(T display, O renderOptions, Level level, BlockPos pos, float tickDelta, BotanyPotBlockEntity pot) {
        return 1.0f;
    }

    public abstract void render(BlockEntityRendererProvider.Context var1, T var2, O var3, PoseStack var4, Level var5, BlockPos var6, float var7, MultiBufferSource var8, int var9, int var10, BotanyPotBlockEntity var11, float var12, float var13, float var14);
}

