/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.addons.jei.crop;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.darkhax.botanypots.common.addons.jei.BotanyPotsJEIPlugin;
import net.darkhax.botanypots.common.addons.jei.crop.CropInfo;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsContent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropCategory
implements IRecipeCategory<CropInfo> {
    private final Component title = Component.translatable((String)"gui.jei.category.botanypots.crop");
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableStatic blankSlot;

    public CropCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(BotanyPotsContent.TAB_ICON.get());
        this.background = guiHelper.createBlankDrawable(155, 57);
        this.blankSlot = guiHelper.getSlotDrawable();
    }

    @NotNull
    public RecipeType<CropInfo> getRecipeType() {
        return BotanyPotsJEIPlugin.CROP;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void onDisplayedIngredientsUpdate(@NotNull CropInfo recipe, @NotNull List<IRecipeSlotDrawable> recipeSlots, @NotNull IFocusGroup focuses) {
        if (recipeSlots.size() >= 2) {
            recipe.inventory().clear();
            recipe.inventory().add(recipeSlots.get(1).getDisplayedItemStack().orElse(ItemStack.EMPTY));
            recipe.inventory().add(recipeSlots.get(0).getDisplayedItemStack().orElse(ItemStack.EMPTY));
            recipe.inventory().add(ItemStack.EMPTY);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CropInfo recipe, @NotNull IFocusGroup focuses) {
        IRecipeSlotBuilder seedSlot = builder.addSlot(RecipeIngredientRole.INPUT, 31, 11);
        seedSlot.addIngredients(recipe.seed());
        seedSlot.addRichTooltipCallback((view, tooltip) -> {
            RecipeHolder<Crop> crop = Crop.getCrop((Level)Minecraft.getInstance().level, recipe.context(), recipe.context().getSeedItem());
            if (crop != null) {
                ((Crop)crop.value()).hoverTooltip(recipe.context().getSeedItem(), recipe.context(), (Level)Minecraft.getInstance().level, arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                if (Minecraft.getInstance().options.advancedItemTooltips) {
                    tooltip.add((FormattedText)Component.translatable((String)"tooltip.botanypots.crop_id", (Object[])new Object[]{recipe.id().toString()}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        });
        IRecipeSlotBuilder soilSlot = builder.addSlot(RecipeIngredientRole.INPUT, 31, 29);
        soilSlot.addIngredients(recipe.soil());
        soilSlot.addRichTooltipCallback((view, tooltip) -> {
            if (Minecraft.getInstance().level != null) {
                view.getDisplayedItemStack().ifPresent(stack -> {
                    RecipeHolder<Soil> soil = Soil.getSoil((Level)Minecraft.getInstance().level, recipe.context(), recipe.context().getSoilItem());
                    if (soil != null) {
                        ((Soil)soil.value()).hoverTooltip((ItemStack)stack, recipe.context(), (Level)Minecraft.getInstance().level, arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                        if (Minecraft.getInstance().options.advancedItemTooltips) {
                            tooltip.add((FormattedText)Component.translatable((String)"tooltip.botanypots.soil_id", (Object[])new Object[]{soil.id().toString()}).withStyle(ChatFormatting.DARK_GRAY));
                        }
                    }
                });
            }
        });
        IRecipeSlotBuilder[] dropSlots = new IRecipeSlotBuilder[12];
        for (int nextSlotId = 0; nextSlotId < dropSlots.length; ++nextSlotId) {
            dropSlots[nextSlotId] = builder.addSlot(RecipeIngredientRole.OUTPUT, 81 + 18 * (nextSlotId % 4), 1 + 18 * (nextSlotId / 4));
        }
        int nextOutputSlot = 0;
        for (ItemDropProvider dropProvider : recipe.drops()) {
            for (ItemStack stack : dropProvider.getDisplayItems()) {
                if (stack.isEmpty()) continue;
                dropSlots[nextOutputSlot].addItemStack(stack);
                if (++nextOutputSlot < dropSlots.length) continue;
                nextOutputSlot = 0;
            }
        }
    }

    public void draw(@NotNull CropInfo recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        this.blankSlot.draw(graphics, 30, 10);
        this.blankSlot.draw(graphics, 30, 28);
        for (int nextSlotId = 0; nextSlotId < 12; ++nextSlotId) {
            this.blankSlot.draw(graphics, 80 + 18 * (nextSlotId % 4), 18 * (nextSlotId / 4));
        }
    }
}

