/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.addons.jei;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.botanypots.common.addons.jei.crop.CropCategory;
import net.darkhax.botanypots.common.addons.jei.crop.CropInfo;
import net.darkhax.botanypots.common.addons.jei.interaction.InteractionCategory;
import net.darkhax.botanypots.common.addons.jei.interaction.InteractionInfo;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BotanyPotsJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = BotanyPotsMod.id("jei_plugin");
    public static final RecipeType<CropInfo> CROP = RecipeType.create((String)"botanypots", (String)"crop", CropInfo.class);
    public static final RecipeType<InteractionInfo> INTERACTION = RecipeType.create((String)"botanypots", (String)"interaction", InteractionInfo.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CropCategory(gui)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InteractionCategory(gui)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            ArrayList<CropInfo> basicCrops = new ArrayList<CropInfo>();
            for (RecipeHolder crop : Objects.requireNonNull((Map)Crop.RECIPES.apply((Level)level)).values()) {
                Recipe recipe = crop.value();
                if (!(recipe instanceof BasicCrop)) continue;
                BasicCrop basic = (BasicCrop)recipe;
                BasicCrop.Properties properties = basic.getBasicProperties();
                basicCrops.add(new CropInfo(crop.id(), properties.input(), properties.soil(), properties.growTime(), properties.drops()));
            }
            registration.addRecipes(CROP, basicCrops);
            ArrayList<InteractionInfo> interactions = new ArrayList<InteractionInfo>();
            for (RecipeHolder interaction : Objects.requireNonNull((Map)PotInteraction.RECIPES.apply((Level)level)).values()) {
                Recipe recipe = interaction.value();
                if (!(recipe instanceof BasicPotInteraction)) continue;
                BasicPotInteraction basic = (BasicPotInteraction)recipe;
                interactions.add(new InteractionInfo(basic));
            }
            registration.addRecipes(INTERACTION, interactions);
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

