/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blocks;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class LaserNode
extends BaseLaserBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final String SCREEN_LASERNODE = "screen.laserio.lasernode";

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem() instanceof LaserWrench) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(blockPos);
            if (be instanceof LaserNodeBE) {
                if (heldItem.getItem() instanceof BaseCard) {
                    IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, (Object)hit.getDirection());
                    ItemStack remainingStack = LaserNode.insertItemToNode(itemHandler, heldItem, false);
                    player.setItemInHand(InteractionHand.MAIN_HAND, remainingStack);
                } else {
                    Direction direction = player.isShiftKeyDown() ? hit.getDirection().getOpposite() : hit.getDirection();
                    IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, (Object)direction);
                    ItemStack cardHolder = LaserNode.findCardHolders(player);
                    if (!cardHolder.isEmpty()) {
                        CardHolder.getUUID(cardHolder);
                    }
                    player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new LaserNodeContainer((LaserNodeBE)be, windowId, (byte)direction.ordinal(), playerInventory, playerEntity, (LaserNodeItemHandler)itemHandler, ContainerLevelAccess.create((Level)be.getLevel(), (BlockPos)be.getBlockPos()), cardHolder), (Component)Component.translatable((String)"")), buf -> {
                        buf.writeBlockPos(blockPos);
                        buf.writeByte((byte)direction.ordinal());
                        ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)cardHolder);
                    });
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack insertItemToNode(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < 9; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static ItemStack findCardHolders(Player player) {
        ItemStack cardHolder = ItemStack.EMPTY;
        Inventory playerInventory = player.getInventory();
        for (int i = 0; i < playerInventory.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)playerInventory.items.get(i);
            if (!(itemStack.getItem() instanceof CardHolder)) continue;
            return itemStack;
        }
        return cardHolder;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof LaserNodeBE) {
                    LaserNodeBE tile = (LaserNodeBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof LaserNodeBE) {
                LaserNodeBE tile = (LaserNodeBE)t;
                tile.tickServer();
            }
        };
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            laserNodeBE.rendersChecked = false;
            laserNodeBE.clearCachedInventories();
            laserNodeBE.redstoneChecked = false;
        }
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity = pBlockAccess.getBlockEntity(pPos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            return laserNodeBE.getRedstoneSide(pSide.getOpposite());
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            if (direction == null || !laserNodeBE.redstoneCardSides.containsKey((byte)direction.getOpposite().ordinal())) {
                return false;
            }
            return laserNodeBE.redstoneCardSides.get((byte)direction.getOpposite().ordinal());
        }
        return false;
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        LaserNodeBE laserNodeBE;
        BlockEntity blockEntity = pBlockAccess.getBlockEntity(pPos);
        if (blockEntity instanceof LaserNodeBE && (laserNodeBE = (LaserNodeBE)blockEntity).getRedstoneSideStrong(pSide.getOpposite())) {
            return laserNodeBE.getRedstoneSide(pSide.getOpposite());
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LaserNodeBE(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return SHAPE;
    }

    public float getShadeBrightness(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (newState.getBlock() != this && (tileEntity = worldIn.getBlockEntity(pos)) != null) {
            for (Direction direction : Direction.values()) {
                IItemHandler cap = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, tileEntity, (Object)direction);
                if (cap == null) continue;
                for (int i = 0; i < cap.getSlots(); ++i) {
                    Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)cap.getStackInSlot(i));
                }
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

