/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities.basebe;

import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.util.MiscTools;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BaseLaserBE
extends BlockEntity {
    protected final Set<BlockPos> connections = new CopyOnWriteArraySet<BlockPos>();
    protected final Set<BlockPos> renderedConnections = new CopyOnWriteArraySet<BlockPos>();
    protected Color laserColor = new Color(1.0f, 0.0f, 0.0f, 0.33f);
    protected int wrenchAlpha = 0;
    protected final Color defaultColor = new Color(1.0f, 0.0f, 0.0f, 0.33f);

    public BaseLaserBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public LaserNodeBE getNodeAt(GlobalPos pos) {
        BlockEntity be = MiscTools.getLevel(this.level.getServer(), pos).getBlockEntity(pos.pos());
        if (be instanceof LaserNodeBE) {
            return (LaserNodeBE)be;
        }
        return null;
    }

    public void setColor(Color color, int wrenchAlpha) {
        this.laserColor = color;
        this.wrenchAlpha = wrenchAlpha;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
    }

    public Color getColor() {
        return this.laserColor;
    }

    public int getWrenchAlpha() {
        return this.wrenchAlpha;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void discoverAllNodes() {
        HashSet<GlobalPos> otherNodesInNetwork = new HashSet<GlobalPos>();
        LinkedList<GlobalPos> nodesToCheck = new LinkedList<GlobalPos>();
        HashSet<GlobalPos> checkedNodes = new HashSet<GlobalPos>();
        nodesToCheck.add(new GlobalPos(this.getLevel().dimension(), this.getBlockPos()));
        while (nodesToCheck.size() > 0) {
            LaserConnectorAdvBE laserConnectorAdvBE;
            BlockEntity be;
            Level nodeLevel;
            GlobalPos posToCheck = (GlobalPos)nodesToCheck.remove();
            if (!checkedNodes.add(posToCheck) || (nodeLevel = MiscTools.getLevel(this.getLevel().getServer(), posToCheck)) == null || !((be = nodeLevel.getBlockEntity(posToCheck.pos())) instanceof BaseLaserBE)) continue;
            BaseLaserBE baseLaserBE = (BaseLaserBE)be;
            Set<GlobalPos> connectedNodes = baseLaserBE.getWorldConnections();
            if (be instanceof LaserConnectorAdvBE && (laserConnectorAdvBE = (LaserConnectorAdvBE)be).getPartnerGlobalPos() != null) {
                connectedNodes.add(laserConnectorAdvBE.getPartnerGlobalPos());
            }
            nodesToCheck.addAll(connectedNodes);
            baseLaserBE.setColor(this.getColor(), this.getWrenchAlpha());
            baseLaserBE.markDirtyClient();
            if (!(be instanceof LaserNodeBE)) continue;
            otherNodesInNetwork.add(posToCheck);
        }
        for (GlobalPos pos : otherNodesInNetwork) {
            LaserNodeBE nodeBE = this.getNodeAt(pos);
            if (nodeBE == null) continue;
            nodeBE.setOtherNodesInNetwork(otherNodesInNetwork);
        }
    }

    public boolean addNode(BlockPos pos) {
        return this.connections.add(this.getRelativePos(pos));
    }

    public boolean addRenderNode(BlockPos pos) {
        boolean success = this.renderedConnections.add(this.getRelativePos(pos));
        if (success) {
            this.markDirtyClient();
        } else {
            this.setChanged();
        }
        return success;
    }

    public boolean removeNode(BlockPos pos) {
        BlockPos relativePos = this.getRelativePos(pos);
        this.connections.remove(relativePos);
        boolean success = this.renderedConnections.remove(relativePos);
        if (success) {
            this.markDirtyClient();
        } else {
            this.setChanged();
        }
        return success;
    }

    public boolean isNodeConnected(BlockPos pos) {
        return this.connections.contains(this.getRelativePos(pos));
    }

    public BlockPos getWorldPos(BlockPos relativePos) {
        return this.getBlockPos().offset((Vec3i)relativePos);
    }

    public BlockPos getRelativePos(BlockPos worldPos) {
        return worldPos.subtract((Vec3i)this.getBlockPos());
    }

    public void handleConnection(BaseLaserBE be) {
        BlockPos connectingPos = be.getBlockPos();
        if (this.isNodeConnected(connectingPos)) {
            this.removeConnection(connectingPos, be);
        } else {
            this.addConnection(connectingPos, be);
        }
    }

    public void addConnection(BlockPos connectingPos, BaseLaserBE be) {
        this.addNode(connectingPos);
        be.addNode(this.getBlockPos());
        if (this.getColor().equals(this.getDefaultColor()) && !be.getColor().equals(be.getDefaultColor())) {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        } else if (be.getColor().equals(be.getDefaultColor()) && !this.getColor().equals(this.getDefaultColor())) {
            be.setColor(this.getColor(), this.getWrenchAlpha());
        } else {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        }
        this.addRenderNode(connectingPos);
        this.discoverAllNodes();
    }

    public void removeConnection(BlockPos connectingPos, BaseLaserBE be) {
        this.removeNode(connectingPos);
        be.removeNode(this.getBlockPos());
        this.discoverAllNodes();
        be.discoverAllNodes();
    }

    public Set<BlockPos> getConnections() {
        return this.connections;
    }

    public Set<GlobalPos> getWorldConnections() {
        HashSet<GlobalPos> worldConnections = new HashSet<GlobalPos>();
        for (BlockPos relativePos : this.connections) {
            worldConnections.add(new GlobalPos(this.level.dimension(), this.getWorldPos(relativePos)));
        }
        return worldConnections;
    }

    public Set<BlockPos> getRenderedConnections() {
        return this.renderedConnections;
    }

    public void disconnectAllNodes() {
        HashSet<BaseLaserBE> connectionsToUpdate = new HashSet<BaseLaserBE>();
        for (BlockPos pos : this.connections) {
            BlockPos connectingPos = this.getWorldPos(pos);
            BlockEntity be = this.level.getBlockEntity(connectingPos);
            if (!(be instanceof BaseLaserBE)) continue;
            ((BaseLaserBE)be).removeNode(this.getBlockPos());
            connectionsToUpdate.add((BaseLaserBE)be);
        }
        this.connections.clear();
        for (BaseLaserBE be : connectionsToUpdate) {
            be.discoverAllNodes();
        }
        this.discoverAllNodes();
    }

    public void validateConnections(BlockPos originalPos) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        HashSet<BaseLaserBE> connectionsToUpdate = new HashSet<BaseLaserBE>();
        BlockPos movedPos = this.getBlockPos().subtract((Vec3i)originalPos);
        for (BlockPos pos : this.connections) {
            BlockPos oldPos = pos.subtract((Vec3i)movedPos);
            BlockPos oldWorldPos = this.getWorldPos(oldPos);
            BlockEntity oldBe = this.level.getBlockEntity(oldWorldPos);
            if (!(oldBe instanceof BaseLaserBE)) continue;
            BaseLaserBE baseLaserBE = (BaseLaserBE)oldBe;
            boolean wasRender = this.renderedConnections.contains(pos);
            baseLaserBE.removeNode(originalPos);
            this.removeNode(baseLaserBE.getBlockPos().offset((Vec3i)movedPos));
            connectionsToUpdate.add(baseLaserBE);
            if (!oldWorldPos.closerThan((Vec3i)this.getBlockPos(), (double)LaserWrench.maxDistance)) continue;
            this.addNode(baseLaserBE.getBlockPos());
            baseLaserBE.addNode(this.getBlockPos());
            if (wasRender) {
                this.addRenderNode(baseLaserBE.getBlockPos());
                continue;
            }
            baseLaserBE.addRenderNode(this.getBlockPos());
        }
        for (BlockPos pos : this.connections) {
            BlockPos connectingPos = this.getWorldPos(pos);
            BlockEntity be = this.level.getBlockEntity(connectingPos);
            if (!(be instanceof BaseLaserBE)) {
                this.removeNode(this.getWorldPos(pos));
                continue;
            }
            BaseLaserBE baseLaserBE = (BaseLaserBE)be;
            baseLaserBE.addNode(this.getBlockPos());
        }
        for (BaseLaserBE be : connectionsToUpdate) {
            be.discoverAllNodes();
        }
        this.discoverAllNodes();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.connections.clear();
        ListTag connections = tag.getList("connections", 10);
        for (int i = 0; i < connections.size(); ++i) {
            BlockPos blockPos = NbtUtils.readBlockPos((CompoundTag)connections.getCompound(i), (String)"pos").orElse(BlockPos.ZERO);
            this.connections.add(blockPos);
        }
        this.renderedConnections.clear();
        ListTag renderedConnections = tag.getList("renderedConnections", 10);
        for (int i = 0; i < renderedConnections.size(); ++i) {
            BlockPos blockPos = NbtUtils.readBlockPos((CompoundTag)renderedConnections.getCompound(i), (String)"pos").orElse(BlockPos.ZERO);
            this.renderedConnections.add(blockPos);
        }
        BlockPos originalPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"myWorldPos").orElse(BlockPos.ZERO);
        if (!originalPos.equals((Object)this.getBlockPos()) && !originalPos.equals((Object)BlockPos.ZERO)) {
            this.validateConnections(originalPos);
        }
        if (tag.contains("laserColor")) {
            int wrenchA = tag.contains("wrenchAlpha") ? tag.getInt("wrenchAlpha") : 0;
            this.setColor(new Color(tag.getInt("laserColor"), true), wrenchA);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag connections = new ListTag();
        for (BlockPos blockPos : this.connections) {
            CompoundTag comp = new CompoundTag();
            comp.put("pos", NbtUtils.writeBlockPos((BlockPos)blockPos));
            connections.add((Object)comp);
        }
        tag.put("connections", (Tag)connections);
        ListTag renderedConnections = new ListTag();
        for (BlockPos blockPos : this.renderedConnections) {
            CompoundTag comp = new CompoundTag();
            comp.put("pos", NbtUtils.writeBlockPos((BlockPos)blockPos));
            renderedConnections.add((Object)comp);
        }
        tag.put("renderedConnections", (Tag)renderedConnections);
        tag.put("myWorldPos", NbtUtils.writeBlockPos((BlockPos)this.getBlockPos()));
        Color color = this.getColor();
        tag.putInt("laserColor", this.getColor().getRGB());
        tag.putInt("wrenchAlpha", this.getWrenchAlpha());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }
}

