/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.events;

import com.direwolf20.laserio.client.events.RenderGUIOverlay;
import com.direwolf20.laserio.client.renderer.BlockOverlayRender;
import com.direwolf20.laserio.client.renderer.DelayedRenderer;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserConnectorAdv;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.util.VectorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class ClientEvents {
    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        GlobalPos selectedDimPos;
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer myplayer = Minecraft.getInstance().player;
        ItemStack myItem = ClientEvents.getWrench((Player)myplayer);
        if (myItem.getItem() instanceof LaserWrench && (selectedDimPos = LaserWrench.getConnectionPos(myItem, myplayer.level())) != null && myplayer.level().dimension().equals(selectedDimPos.dimension())) {
            BlockEntity be = myplayer.level().getBlockEntity(selectedDimPos.pos());
            if (!selectedDimPos.pos().equals((Object)BlockPos.ZERO) && be instanceof BaseLaserBE) {
                BlockOverlayRender.renderSelectedBlock(evt, selectedDimPos.pos(), (BaseLaserBE)be);
            }
        }
        DelayedRenderer.render(evt.getPoseStack());
        DelayedRenderer.renderConnections(evt.getPoseStack());
    }

    public static ItemStack getWrench(Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof LaserWrench) && !((heldItem = player.getOffhandItem()).getItem() instanceof LaserWrench)) {
            return ItemStack.EMPTY;
        }
        return heldItem;
    }

    @SubscribeEvent
    static void renderGUIOverlay(CustomizeGuiOverlayEvent.DebugText evt) {
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = player.level();
        ItemStack wrench = ClientEvents.getWrench((Player)player);
        if (!(wrench.getItem() instanceof LaserWrench)) {
            return;
        }
        int range = 10;
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)player, ClipContext.Fluid.NONE, range);
        if (lookingAt == null || !(level.getBlockState(VectorHelper.getLookingAt((Player)player, wrench, range).getBlockPos()).getBlock() instanceof LaserConnectorAdv)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(lookingAt.getBlockPos());
        if (blockEntity instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)blockEntity;
            GuiGraphics guiGraphics = evt.getGuiGraphics();
            Font font = Minecraft.getInstance().font;
            RenderGUIOverlay.renderLocation(font, guiGraphics, laserConnectorAdvBE);
        }
    }
}

