/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.fireproofboats.mixin;

import cy.jdkdigital.fireproofboats.FireproofBoats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.extensions.IBoatExtension;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Boat.class})
public abstract class MixinBoat
extends Entity
implements IBoatExtension {
    @Shadow
    public abstract Boat.Type getVariant();

    public MixinBoat(EntityType<?> type, Level level) {
        super(type, level);
    }

    public boolean fireImmune() {
        return FireproofBoats.isFireproofBoat(this.getVariant()) || super.fireImmune();
    }

    @Inject(at={@At(value="RETURN")}, method={"getDropItem"}, cancellable=true)
    public void getDropItem(CallbackInfoReturnable<Item> cir) {
        if (this.getVariant().equals((Object)FireproofBoats.CRIMSON_TYPE)) {
            cir.setReturnValue((Object)((Item)FireproofBoats.CRIMSON_BOAT.get()));
        } else if (this.getVariant().equals((Object)FireproofBoats.WARPED_TYPE)) {
            cir.setReturnValue((Object)((Item)FireproofBoats.WARPED_BOAT.get()));
        }
    }

    public boolean canBoatInFluid(FluidState state) {
        Boat boat = (Boat)this;
        return state.supportsBoating(boat) || state.getFluidType().equals(Fluids.LAVA.getFluidType()) && FireproofBoats.isFireproofBoat(this.getVariant());
    }

    public boolean canBoatInFluid(FluidType type) {
        Boat boat = (Boat)this;
        return type.supportsBoating(boat) || type.equals(Fluids.LAVA.getFluidType()) && FireproofBoats.isFireproofBoat(this.getVariant());
    }
}

