/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.OpenSimplex2F;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NoiseReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final MapCodec<NoiseReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("output_block").forGetter(config -> config.outputBlock), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("threshold").forGetter(config -> Float.valueOf(config.threshold)), (App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale))).apply((Applicative)instance, instance.stable(NoiseReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Block outputBlock;
    private final float threshold;
    private final float xzScale;
    private final float yScale;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public NoiseReplaceWithPropertiesProcessor(Block inputBlock, Block outputBlock, float threshold, float xzScale, float yScale) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.threshold = threshold;
        this.xzScale = xzScale;
        this.yScale = yScale;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        BlockPos worldPos;
        double noiseVal;
        this.setSeed(worldReader instanceof WorldGenRegion ? ((WorldGenRegion)worldReader).getSeed() : 0L);
        if (infoIn2.state().getBlock() == this.inputBlock && (noiseVal = this.noiseGenerator.noise3_Classic((float)(worldPos = infoIn2.pos()).getX() * this.xzScale, (float)worldPos.getY() * this.yScale, (float)worldPos.getZ() * this.xzScale)) / 2.0 + 0.5 < (double)this.threshold) {
            BlockState newBlockState = this.outputBlock.defaultBlockState();
            newBlockState = GeneralUtils.copyBlockProperties(infoIn2.state(), newBlockState);
            return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), newBlockState, infoIn2.nbt());
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.NOISE_REPLACE_WITH_PROPERTIES_PROCESSOR.get();
    }
}

