/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.placements;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class MinDistanceFromWorldOriginPlacement
extends PlacementModifier {
    public static final MapCodec<MinDistanceFromWorldOriginPlacement> CODEC = ExtraCodecs.NON_NEGATIVE_INT.fieldOf("min_distance_from_world_origin").xmap(MinDistanceFromWorldOriginPlacement::new, countPlacement -> countPlacement.minDistanceFromWorldOrigin);
    private final int minDistanceFromWorldOrigin;

    private MinDistanceFromWorldOriginPlacement(int intProvider) {
        this.minDistanceFromWorldOrigin = intProvider;
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        return blockPos.distManhattan((Vec3i)BlockPos.ZERO) > this.minDistanceFromWorldOrigin ? Stream.of(blockPos) : Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return RSPlacements.MIN_DISTANCE_FROM_WORLD_ORIGIN_PLACEMENT.get();
    }
}

