/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetLengthRangeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureVine
extends Feature<StructureTargetLengthRangeConfig> {
    public StructureVine(Codec<StructureTargetLengthRangeConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetLengthRangeConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ((StructureTargetLengthRangeConfig)context.config()).attempts; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(((StructureTargetLengthRangeConfig)context.config()).xzRange * 2 + 1) - ((StructureTargetLengthRangeConfig)context.config()).xzRange, context.random().nextInt(((StructureTargetLengthRangeConfig)context.config()).heightRange) - 1, context.random().nextInt(((StructureTargetLengthRangeConfig)context.config()).xzRange * 2 + 1) - ((StructureTargetLengthRangeConfig)context.config()).xzRange);
            if (!context.level().isEmptyBlock((BlockPos)mutable)) continue;
            BlockPos.MutableBlockPos vineMutablePos = new BlockPos.MutableBlockPos().set((Vec3i)mutable);
            ChunkPos currentChunkPos = new ChunkPos((BlockPos)vineMutablePos);
            int maxLength = ((StructureTargetLengthRangeConfig)context.config()).length - context.random().nextInt(context.random().nextInt(((StructureTargetLengthRangeConfig)context.config()).length) + 1);
            int targetY = vineMutablePos.getY() - maxLength;
            while (vineMutablePos.getY() >= targetY && context.level().isEmptyBlock((BlockPos)vineMutablePos)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)vineMutablePos).move(direction);
                    ChunkPos newChunkPos = new ChunkPos((BlockPos)mutable);
                    if (newChunkPos.x != currentChunkPos.x || newChunkPos.z != currentChunkPos.z) continue;
                    BlockState currentBlockstate = (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.TRUE);
                    BlockState aboveBlockstate = context.level().getBlockState(vineMutablePos.above());
                    if (currentBlockstate.canSurvive((LevelReader)context.level(), (BlockPos)vineMutablePos) && context.level().getBlockState(vineMutablePos.relative(direction)).getBlock() != Blocks.MOSS_CARPET) {
                        context.level().setBlock((BlockPos)vineMutablePos, (BlockState)currentBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(aboveBlockstate.canOcclude())), 2);
                        break;
                    }
                    if (!aboveBlockstate.is(Blocks.VINE)) continue;
                    context.level().setBlock((BlockPos)vineMutablePos, (BlockState)aboveBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(false)), 2);
                    break;
                }
                vineMutablePos.move(Direction.DOWN);
            }
        }
        return true;
    }
}

