/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.ItemFrameConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ItemFrameWithRandomItem
extends Feature<ItemFrameConfig> {
    public ItemFrameWithRandomItem(Codec<ItemFrameConfig> code) {
        super(code);
    }

    public boolean place(FeaturePlaceContext<ItemFrameConfig> context) {
        ItemFrameConfig config = (ItemFrameConfig)context.config();
        BlockPos targetSpot = context.origin();
        Direction direction = null;
        if (config.attachment == ItemFrameConfig.Attachment.FLOOR) {
            direction = Direction.UP;
        } else if (config.attachment == ItemFrameConfig.Attachment.CEILING) {
            direction = Direction.DOWN;
        } else {
            for (Direction side : Direction.Plane.HORIZONTAL) {
                BlockPos sidePos = targetSpot.relative(side);
                BlockState sideBlock = context.level().getBlockState(sidePos);
                if (!sideBlock.isFaceSturdy((BlockGetter)context.level(), sidePos, side)) continue;
                direction = side.getOpposite();
                break;
            }
            if (direction == null) {
                return false;
            }
        }
        ItemFrame itemFrame = new ItemFrame((Level)context.level().getLevel(), targetSpot, direction);
        HolderSet<Item> items = config.itemToPickFrom;
        if (items.size() > 0) {
            itemFrame.setItem(((Item)((Holder)items.getRandomElement(context.random()).get()).value()).getDefaultInstance(), false);
        }
        context.level().addFreshEntityWithPassengers((Entity)itemFrame);
        return true;
    }
}

