/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.HoneyCrystalFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HoneyCrystalFeature
extends Feature<HoneyCrystalFeatureConfig> {
    public HoneyCrystalFeature(Codec<HoneyCrystalFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<HoneyCrystalFeatureConfig> context) {
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        BlockState originalBlockstate = context.level().getBlockState((BlockPos)blockpos$Mutable);
        ChunkPos currentChunkPos = new ChunkPos((BlockPos)blockpos$Mutable);
        if (originalBlockstate.getBlock() == Blocks.CAVE_AIR || ((HoneyCrystalFeatureConfig)context.config()).exposed && originalBlockstate.isAir() && !originalBlockstate.is(BzTags.AIR_LIKE) || originalBlockstate.getFluidState().is(FluidTags.WATER) && originalBlockstate.getCollisionShape((BlockGetter)context.level(), (BlockPos)blockpos$Mutable).isEmpty()) {
            for (Direction face : Direction.values()) {
                blockpos$Mutable.set((Vec3i)context.origin());
                BlockState blockstate = context.level().getBlockState((BlockPos)blockpos$Mutable.move(face, 7));
                if (((HoneyCrystalFeatureConfig)context.config()).exposed || blockstate.getBlock() != Blocks.AIR) continue;
                return false;
            }
            BlockState honeyCrystal = (BlockState)((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState().setValue((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(originalBlockstate.getFluidState().is(FluidTags.WATER)));
            blockpos$Mutable.set((Vec3i)context.origin());
            for (Direction facing : Direction.values()) {
                BlockState result;
                if (!(honeyCrystal = (BlockState)honeyCrystal.setValue((Property)HoneyCrystal.FACING, (Comparable)facing)).canSurvive((LevelReader)context.level(), (BlockPos)blockpos$Mutable) || (result = HoneyCrystal.updateFromNeighbourShapes((BlockState)honeyCrystal, (LevelAccessor)context.level(), (BlockPos)blockpos$Mutable)).getBlock() == Blocks.AIR) continue;
                Direction directionProp = (Direction)result.getValue((Property)HoneyCrystal.FACING);
                blockpos$Mutable.move(directionProp.getOpposite());
                if (blockpos$Mutable.getX() >> 4 != currentChunkPos.x || blockpos$Mutable.getZ() >> 4 != currentChunkPos.z) {
                    return false;
                }
                blockpos$Mutable.move(directionProp);
                context.level().setBlock((BlockPos)blockpos$Mutable, result, 3);
                return true;
            }
        }
        return false;
    }
}

