/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei;

import com.telepathicgrunt.the_bumblezone.modcompat.JEIIntegration;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.DrawableBuilder;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class QueenTradesJEICategory
implements IRecipeCategory<JEIQueenTradesInfo> {
    public static final int RECIPE_WIDTH = 124;
    public static final int RECIPE_HEIGHT = 28;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final IDrawable tagIcon;

    public QueenTradesJEICategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/queen_trades_layout.png"), 0, 0, 124, 28);
        this.localizedName = Component.translatable((String)"the_bumblezone.recipe_viewers.bee_queen_trades");
        DrawableBuilder iconBuilder = new DrawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/bee_queen_trades.png"), 0, 0, 16, 16);
        iconBuilder.setTextureSize(16, 16);
        this.icon = iconBuilder.build();
        DrawableBuilder tagIconBuilder = new DrawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/tag_icon.png"), 0, 0, 16, 16);
        tagIconBuilder.setTextureSize(16, 16);
        this.tagIcon = tagIconBuilder.build();
    }

    public RecipeType<JEIQueenTradesInfo> getRecipeType() {
        return JEIIntegration.QUEEN_TRADES;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(JEIQueenTradesInfo recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_xp", (Object[])new Object[]{recipe.reward.xpReward}), 100, 11, -8355712, false);
        double percentValue = (double)recipe.reward.weight / (double)recipe.reward.getTotalWeight() * 100.0;
        if (recipe.reward.tagKey.isPresent() && recipe.outputFocused) {
            percentValue *= (double)recipe.reward.weight / (double)((HolderSet.Named)BuiltInRegistries.ITEM.getTag(recipe.reward.tagKey.get()).get()).size();
        }
        String percentRounded = percentValue < 1.0 ? String.valueOf(Math.max((double)Math.round(percentValue * 10.0) / 10.0, 0.1)) : String.valueOf(Math.max(Math.round(percentValue), 1L));
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_chance_text", (Object[])new Object[]{percentRounded}), 38 - (percentValue < 1.0 ? 6 : percentRounded.length() * 3), 11, -8355712, false);
        if (recipe.input.tagKey().isPresent()) {
            this.tagIcon.draw(guiGraphics, 11, 11);
        }
        if (recipe.reward.tagKey.isPresent() && !recipe.outputFocused) {
            this.tagIcon.draw(guiGraphics, 69, 11);
        }
    }

    public List<Component> getTooltipStrings(JEIQueenTradesInfo recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 32.0 && mouseX < 54.0 && mouseY > 4.0 && mouseY < 24.0) {
            double percent = (double)recipe.reward.weight / (double)recipe.reward.getTotalWeight() * 100.0;
            if (recipe.reward.tagKey.isPresent() && recipe.outputFocused) {
                percent *= (double)recipe.reward.weight / (double)((HolderSet.Named)BuiltInRegistries.ITEM.getTag(recipe.reward.tagKey.get()).get()).size();
            }
            String percentString = String.valueOf(percent);
            return List.of(Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_chance_tooltip", (Object[])new Object[]{percentString.substring(0, Math.min(percentString.length(), 5))}));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JEIQueenTradesInfo recipe, IFocusGroup focuses) {
        if (recipe.input.tagKey().isPresent()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).addItemStacks(((HolderSet.Named)BuiltInRegistries.ITEM.getTag(recipe.input.tagKey().get()).get()).stream().map(e -> ((Item)e.value()).getDefaultInstance()).toList());
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).addItemStack(recipe.input.item().getDefaultInstance());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 64, 6).addItemStacks(recipe.reward.getItems());
        recipe.outputFocused = !focuses.isEmpty() && ((IFocus)focuses.getAllFocuses().get(0)).getRole() == RecipeIngredientRole.OUTPUT;
    }
}

