/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge.framedblocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.CarvableWax;
import com.telepathicgrunt.the_bumblezone.items.BzBlockItem;
import com.telepathicgrunt.the_bumblezone.modcompat.neoforge.framedblocks.CarvableWaxBlockCamoContainer;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.TriggerRegistrar;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainer;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainerFactory;
import xfacthd.framedblocks.api.util.Utils;

final class CarvableWaxBlockCamoContainerFactory
extends AbstractBlockCamoContainerFactory<CarvableWaxBlockCamoContainer> {
    private static final MapCodec<CarvableWaxBlockCamoContainer> CODEC = BlockState.CODEC.xmap(CarvableWaxBlockCamoContainer::new, AbstractBlockCamoContainer::getState).fieldOf("state");
    private static final StreamCodec<ByteBuf, CarvableWaxBlockCamoContainer> STREAM_CODEC = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).map(CarvableWaxBlockCamoContainer::new, AbstractBlockCamoContainer::getState);

    CarvableWaxBlockCamoContainerFactory() {
    }

    @Nullable
    protected BlockState getStateFromItemStack(Level level, BlockPos pos, Player player, ItemStack stack) {
        BzBlockItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof BzBlockItem && (item = (BzBlockItem)item2).getBlock() instanceof CarvableWax) {
            return item.getBlockState();
        }
        return null;
    }

    protected CarvableWaxBlockCamoContainer createContainer(BlockState camoState, Level level, BlockPos pos, Player player, ItemStack stack) {
        return new CarvableWaxBlockCamoContainer(camoState);
    }

    protected CarvableWaxBlockCamoContainer copyContainerWithState(CarvableWaxBlockCamoContainer original, BlockState newCamoState) {
        return new CarvableWaxBlockCamoContainer(newCamoState);
    }

    protected boolean isValidBlock(BlockState camoState, BlockGetter level, BlockPos pos, @Nullable Player player) {
        return camoState.getBlock() instanceof CarvableWax;
    }

    public boolean canTriviallyConvertToItemStack() {
        return true;
    }

    public ItemStack dropCamo(CarvableWaxBlockCamoContainer container) {
        Block block = container.getState().getBlock();
        if (block instanceof CarvableWax) {
            CarvableWax carvableWax = (CarvableWax)block;
            return carvableWax.toItemStack(container.getState());
        }
        return new ItemStack((ItemLike)container.getState().getBlock());
    }

    protected ItemStack createItemStack(Level level, BlockPos pos, Player player, ItemStack stack, CarvableWaxBlockCamoContainer container) {
        return this.dropCamo(container);
    }

    protected void writeToNetwork(CompoundTag tag, CarvableWaxBlockCamoContainer container) {
        tag.putInt("state", Block.getId((BlockState)container.getState()));
    }

    protected CarvableWaxBlockCamoContainer readFromNetwork(CompoundTag tag) {
        BlockState state = Block.stateById((int)tag.getInt("state"));
        return new CarvableWaxBlockCamoContainer(state);
    }

    public MapCodec<CarvableWaxBlockCamoContainer> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, CarvableWaxBlockCamoContainer> streamCodec() {
        return STREAM_CODEC;
    }

    public void registerTriggerItems(TriggerRegistrar registrar) {
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_WAVY.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_FLOWER.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_CHISELED.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_DIAMOND.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_BRICKS.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_CHAINS.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_MUSIC.get());
        registrar.registerApplicationItem((Item)BzItems.CARVABLE_WAX_GRATE.get());
        registrar.registerRemovalItem((Item)Utils.FRAMED_HAMMER.value());
    }
}

