/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdAstraCompat
implements ModCompat {
    private static Item JET_HELMET = null;
    private static Item JET_CHEST = null;
    private static Item JET_LEGS = null;
    private static Item JET_FEET = null;

    public AdAstraCompat() {
        JET_HELMET = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"ad_astra", (String)"jet_suit_helmet"));
        JET_CHEST = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"ad_astra", (String)"jet_suit"));
        JET_LEGS = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"ad_astra", (String)"jet_suit_pants"));
        JET_FEET = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"ad_astra", (String)"jet_suit_boots"));
        ModChecker.adAstraPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.HEAVY_AIR_RESTRICTED);
    }

    @Override
    public void restrictFlight(Entity entity, double extraGravity) {
        Player player;
        if (entity instanceof Player && AdAstraCompat.hasItemEquipped(player = (Player)entity, EquipmentSlot.HEAD, JET_HELMET) && AdAstraCompat.hasItemEquipped(player, EquipmentSlot.CHEST, JET_CHEST) && AdAstraCompat.hasItemEquipped(player, EquipmentSlot.LEGS, JET_LEGS) && AdAstraCompat.hasItemEquipped(player, EquipmentSlot.FEET, JET_FEET)) {
            ItemStack jetpackSuit = player.getItemBySlot(EquipmentSlot.CHEST);
            if (!player.getCooldowns().isOnCooldown(jetpackSuit.getItem()) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_jetpack").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
            }
            player.getCooldowns().addCooldown(jetpackSuit.getItem(), 40);
        }
    }

    private static boolean hasItemEquipped(Player player, EquipmentSlot slot, Item itemToMatch) {
        return itemToMatch != null && player.getItemBySlot(slot).is(itemToMatch);
    }
}

