/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.SentryWatcherEntity;
import com.telepathicgrunt.the_bumblezone.mixin.items.ItemAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class SentryWatcherSpawnEgg
extends Item {
    private final Supplier<? extends EntityType<? extends Entity>> entityType;
    public static final UUID DISPENSER_OWNER_UUID = new UUID(0L, 0L);

    public SentryWatcherSpawnEgg(Supplier<? extends EntityType<? extends Entity>> typeIn, Item.Properties builder) {
        super(builder);
        this.entityType = typeIn;
        this.setupDispenserBehavior();
    }

    protected void setupDispenserBehavior() {
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            @NotNull
            public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                EntityType<?> entitytype = ((SentryWatcherSpawnEgg)stack.getItem()).getType(stack);
                Entity entity = entitytype.spawn(source.level(), stack, null, source.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                if (entity instanceof SentryWatcherEntity) {
                    SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                    sentryWatcherEntity.setTargetFacing(direction);
                    sentryWatcherEntity.setOwner(Optional.of(DISPENSER_OWNER_UUID));
                }
                stack.shrink(1);
                return stack;
            }
        });
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.getItemInHand();
        BlockPos blockPos = useOnContext.getClickedPos();
        Direction direction = useOnContext.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.is(Blocks.SPAWNER)) {
            if (!player.getAbilities().instabuild) {
                if (player instanceof ServerPlayer) {
                    player.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.sentry_watcher_egg_spawner_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), true);
                }
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                EntityType<?> entityType = this.getType(itemStack);
                spawnerBlockEntity.setEntityId(entityType, level.getRandom());
                blockEntity.setChanged();
                level.sendBlockUpdated(blockPos, blockState, blockState, 3);
                level.gameEvent((Entity)useOnContext.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                itemStack.shrink(1);
                return InteractionResult.CONSUME;
            }
        }
        BlockPos blockPos2 = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        EntityType<?> entityType2 = this.getType(itemStack);
        Entity entity = entityType2.spawn((ServerLevel)level, itemStack, useOnContext.getPlayer(), blockPos2, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos2) && direction == Direction.UP);
        if (entity != null) {
            if (entity instanceof SentryWatcherEntity) {
                SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                if (useOnContext.getClickedFace().getAxis() != Direction.Axis.Y) {
                    sentryWatcherEntity.setTargetFacing(useOnContext.getHorizontalDirection().getOpposite());
                } else {
                    sentryWatcherEntity.setTargetFacing(useOnContext.getHorizontalDirection());
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((GenericTrigger)((Object)BzCriterias.SENTRY_WATCHER_SPAWN_EGG_USED_TRIGGER.get())).trigger(serverPlayer);
                }
                sentryWatcherEntity.setOwner(Optional.of(player.getUUID()));
                if (player instanceof ServerPlayer) {
                    player.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.sentry_watcher_egg_removal_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), true);
                }
            }
            itemStack.shrink(1);
            level.gameEvent((Entity)useOnContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockPos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = ItemAccessor.bumblezone$callGetPlayerPOVHitResult(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!(level.getBlockState(blockPos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos, blockHitResult.getDirection(), itemStack)) {
            EntityType<?> entityType = this.getType(itemStack);
            Entity entity = entityType.spawn((ServerLevel)level, itemStack, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)itemStack);
            }
            if (entity instanceof SentryWatcherEntity) {
                SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                sentryWatcherEntity.setTargetFacing(player.getDirection());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((GenericTrigger)((Object)BzCriterias.SENTRY_WATCHER_SPAWN_EGG_USED_TRIGGER.get())).trigger(serverPlayer);
                }
                if (!player.getAbilities().instabuild) {
                    sentryWatcherEntity.setOwner(Optional.of(player.getUUID()));
                    if (player instanceof ServerPlayer) {
                        player.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.sentry_watcher_egg_removal_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), true);
                    }
                }
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public EntityType<?> getType(ItemStack itemStack) {
        CompoundTag compoundTag2;
        CompoundTag compoundTag;
        if (itemStack.has(DataComponents.ENTITY_DATA) && (compoundTag = ((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).getUnsafe()).contains("EntityTag") && (compoundTag2 = compoundTag.getCompound("EntityTag")).contains("id", 8)) {
            return EntityType.byString((String)compoundTag2.getString("id")).orElse(this.entityType.get());
        }
        return this.entityType.get();
    }
}

