/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HoneyCrystalShardEntity
extends AbstractArrow {
    public HoneyCrystalShardEntity(EntityType<? extends HoneyCrystalShardEntity> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(4.0);
        this.setCritArrow(true);
    }

    public HoneyCrystalShardEntity(Level level, LivingEntity livingEntity, ItemStack ammo, @Nullable ItemStack weapon) {
        super((EntityType)BzEntities.HONEY_CRYSTAL_SHARD.get(), livingEntity, level, ammo, weapon);
        this.setBaseDamage(4.0);
        this.setCritArrow(true);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (!this.inGround && this.level().getGameTime() % 5L == (long)this.random.nextInt(3)) {
                this.makeParticle(1);
            }
        } else if (this.inGround && this.inGroundTime != 0 && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
        }
    }

    private void makeParticle(int particlesToSpawn) {
        if (particlesToSpawn > 0) {
            float red = 0.8f;
            float green = 0.6f;
            float blue = 0.1f;
            for (int i = 0; i < particlesToSpawn; ++i) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)red, (float)green, (float)blue), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected boolean tryPickup(Player player) {
        if (player.position().closerThan((Position)this.position(), (double)0.85f)) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                HoneyCrystalShardEntity.showParticles(serverLevel, player.getRandom(), (Entity)this, 5);
                this.level().playSound(null, player.blockPosition(), (SoundEvent)BzSounds.HONEY_CRYSTAL_SHARD_SHATTER.get(), SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.2f + 0.6f);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return false;
        }
        return false;
    }

    private static void showParticles(ServerLevel serverLevel, RandomSource random, Entity entity, int particleNumber) {
        BlockState blockstate = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), entity.getX(), entity.getY(), entity.getZ(), particleNumber, (double)random.nextFloat() * 0.5 - 0.25, (double)(random.nextFloat() * 0.2f + 0.2f), (double)random.nextFloat() * 0.5 - 0.25, (double)random.nextFloat() * 0.4 + (double)0.2f);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)BzSounds.HONEY_CRYSTAL_SHARD_HIT.get();
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

